import tkinter as tk
from tkinter import messagebox
import sqlite3
import os
from fpdf import FPDF
from datetime import datetime
import win32com.client
import os
import sqlite3
from tkinter import messagebox
import atexit

# Pfad zur Datenbankdatei
database_path = os.path.join(os.path.dirname(__file__), "bewerbung.db")

def get_db_connection():
    return sqlite3.connect(database_path)

# Drop the existing table if it exists and create a new one
def create_table():
    try:
        conn = get_db_connection()
        c = conn.cursor()
        c.execute('DROP TABLE IF EXISTS bewerbungen')  # Drop the table if it exists
        c.execute('''
            CREATE TABLE bewerbungen (
                id INTEGER PRIMARY KEY,
                art TEXT,
                name TEXT,
                praktikum TEXT,
                firma TEXT,
                telefon TEXT,
                anrede TEXT,
                ansprechpartner TEXT,
                betreff TEXT,
                nachricht TEXT,
                datum TEXT
            )
        ''')
        conn.commit()
    except sqlite3.Error as e:
        messagebox.showerror("Fehler", f"Fehler beim Erstellen der Tabelle: {e}")

# Rufe die Funktion auf, um die Tabelle zu erstellen, falls sie noch nicht existiert
create_table()

def speichere_bewerbung(art, name, praktikum, firma, telefon, anrede, ansprechpartner, betreff, nachricht):
    try:
        conn = get_db_connection()
        c = conn.cursor()
        datum = datetime.now().strftime("%Y-%m-%d %H:%M:%S")
        c.execute('''
            INSERT INTO bewerbungen (art, name, praktikum, firma, telefon, anrede, ansprechpartner, betreff, nachricht, datum)
            VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
        ''', (art, name, praktikum, firma, telefon, anrede, ansprechpartner, betreff, nachricht, datum))
        conn.commit()
    except sqlite3.Error as e:
        messagebox.showerror("Fehler", f"Fehler beim Speichern der Bewerbung: {e}")
    finally:
        conn.close()

def generiere_bewerbung(art, name, praktikum, firma, telefon, anrede, ansprechpartner):
    if art == "Bewerbung":
        betreff = "Bewerbung für ein Praktikum"
        nachricht = (
            f"Sehr geehrte(r) {anrede} {ansprechpartner},\n\n"
            f"ich bin {name} und mache eine Umschulung im Bereich {praktikum}. "
            f"Mit großem Interesse habe ich von den spannenden Projekten und den "
            f"innovativen Ansätzen Ihres Unternehmens {firma} gehört. "
            f"Ich bin überzeugt, dass ein Praktikum bei Ihnen eine hervorragende Möglichkeit wäre, "
            f"praktische Erfahrungen zu sammeln und meine Kenntnisse zu vertiefen.\n\n"
            f"Im Rahmen meiner Umschulung habe ich bereits umfangreiche theoretische Kenntnisse erworben und "
            f"möchte diese nun durch praktische Erfahrungen ergänzen. Ihr Unternehmen bietet hierfür die ideale "
            f"Plattform, da es für seine herausragende Innovationskraft und sein angenehmes Arbeitsklima bekannt ist.\n\n"
            f"Über eine Einladung zu einem persönlichen Gespräch würde ich mich sehr freuen.\n\n"
            f"Mit freundlichen Grüßen,\n"
            f"{name}\n"
            f"Tel.: {telefon}"
        )
    elif art == "Anfrage":
        betreff = "Anfrage auf ein Praktikum"
        nachricht = (
            f"Sehr geehrte(r) {anrede} {ansprechpartner},\n\n"
            f"mein Name ist {name} und ich mache eine Umschulung im Bereich {praktikum}. "
            f"Ich interessiere mich sehr für ein Praktikum bei Ihrem Unternehmen {firma}. "
            f"Ich würde gerne mehr über die Möglichkeiten und Rahmenbedingungen für ein Praktikum in Ihrem Hause erfahren.\n\n"
            f"Da Ihr Unternehmen für seine innovativen Projekte und sein dynamisches Team bekannt ist, bin ich überzeugt, dass "
            f"ich bei Ihnen wertvolle Erfahrungen sammeln und mein Wissen erweitern kann.\n\n"
            f"Über eine positive Rückmeldung würde ich mich sehr freuen.\n\n"
            f"Mit freundlichen Grüßen,\n"
            f"{name}\n"
            f"Tel.: {telefon}"
        )
    else:
        messagebox.showerror("Fehler", "Ungültige Option.")
        return None, None

    return betreff, nachricht

def zeige_bewerbung():
    art = art_var.get()
    name = name_entry.get()
    praktikum = beruf_var.get()
    firma = firma_entry.get()
    telefon = telefon_entry.get()
    anrede = anrede_var.get()
    ansprechpartner = ansprechpartner_entry.get()
    datum = datetime.now().strftime("%Y-%m-%d %H:%M:%S")
    datum_entry.config(state="normal")  # Set entry to normal to update value
    datum_entry.delete(0, tk.END)
    datum_entry.insert(0, datum)
    datum_entry.config(state="disabled")  # Disable entry after updating

    betreff, nachricht = generiere_bewerbung(art, name, praktikum, firma, telefon, anrede, ansprechpartner)

    if betreff and nachricht:
        result_text.delete("1.0", tk.END)
        result_text.insert(tk.END, f"Betreff: {betreff}\n\n{nachricht}")
        speichere_bewerbung(art, name, praktikum, firma, telefon, anrede, ansprechpartner, betreff, nachricht)

def erzeuge_pdf(firma_name):
    conn = get_db_connection()
    c = conn.cursor()
    c.execute('SELECT betreff, nachricht, datum FROM bewerbungen WHERE firma=?', (firma_name,))
    resultate = c.fetchall()
    conn.close()

    pdf = FPDF()
    pdf.add_page()
    pdf.set_font("Arial", size=12)

    for betreff, nachricht, datum in resultate:
        pdf.cell(200, 10, txt=f"Betreff: {betreff}", ln=True)
        pdf.cell(200, 10, txt=f"Datum: {datum}", ln=True)
        pdf.multi_cell(0, 10, nachricht)
        pdf.ln()

    pdf_file = f"{firma_name}_bewerbungen.pdf"
    pdf.output(pdf_file)
    os.startfile(pdf_file)

def oeffne_in_outlook():
    try:
        outlook = win32com.client.Dispatch("Outlook.Application")
        mail = outlook.CreateItem(0)
        mail.Subject = f"Betreff: {result_text.get('1.0', '1.60')}"
        mail.Body = result_text.get('1.61', 'end-1c')
        mail.Display()
    except Exception as e:
        messagebox.showerror("Fehler", f"Fehler beim Öffnen von Outlook: {e}")

def zeige_historie_fenster():
    # Create a new window for the history
    historie_window = tk.Toplevel(app)
    historie_window.title("Bewerbungshistorie")
    historie_window.geometry("600x500")  # Erhöhte Fenstergröße
    historie_window.configure(bg="#d0f0f0")

    # Add back button to return to the main frame
    back_btn_style = {
        "font": ("Helvetica", 12, "bold"),
        "fg": "white",
        "bg": "#4682b4",  # Mittelblau
        "padx": 20,
        "pady": 10,
        "relief": "flat",
        "highlightthickness": 0,
        "bd": 0
    }
    # Create a frame for the listbox and scrollbar
    frame = tk.Frame(historie_window, bg="#d0f0f0")
    frame.pack(fill=tk.BOTH, expand=True, padx=10, pady=10)

    # Create a scrollbar
    scrollbar = tk.Scrollbar(frame)
    scrollbar.pack(side=tk.RIGHT, fill=tk.Y)

    # Create a listbox to display the company names with scrollbar
    listbox = tk.Listbox(frame, font=("Helvetica", 12, "bold"), fg="#4682b4", bg="#f0f8ff", yscrollcommand=scrollbar.set)
    listbox.pack(side=tk.LEFT, fill=tk.BOTH, expand=True)
    scrollbar.config(command=listbox.yview)

    # Text area to display the generated text
    text_area = tk.Text(frame, height=20, width=60, wrap="word", font=("Helvetica", 12), bg="#f0f8ff", relief="solid", padx=5, pady=5)
    text_area.pack(side=tk.RIGHT, fill=tk.BOTH, expand=True)
    text_area.config(state="disabled")

    # Query distinct company names with past applications
    conn = get_db_connection()
    c = conn.cursor()
    c.execute('SELECT firma, id FROM bewerbungen')
    bewerbungen = c.fetchall()
    conn.close()

    for firma, bewerbung_id in bewerbungen:
        listbox.insert(tk.END, firma)

    def on_select(event):
        widget = event.widget
        selection = widget.curselection()
        if selection:
            index = selection[0]
            firma = widget.get(index)

            # Query the selected company's applications
            conn = get_db_connection()
            c = conn.cursor()
            c.execute('SELECT betreff, nachricht FROM bewerbungen WHERE firma=?', (firma,))
            result = c.fetchone()
            conn.close()

            betreff, nachricht = result

            # Display the text in the text area
            text_area.config(state="normal")
            text_area.delete("1.0", tk.END)
            text_area.insert(tk.END, f"Betreff: {betreff}\n\n{nachricht}")
            text_area.config(state="disabled")

    listbox.bind('<<ListboxSelect>>', on_select)

    def generiere_pdf():
        selection = listbox.curselection()
        if selection:
            index = selection[0]
            firma = listbox.get(index)
            erzeuge_pdf(firma)

    # PDF-Generierungsbutton hinzufügen
    pdf_btn_style = {
        "font": ("Helvetica", 12, "bold"),
        "fg": "white",
        "bg": "#4caf50",  # Grün
        "padx": 20,
        "pady": 10,
        "relief": "flat",
        "highlightthickness": 0,
        "bd": 0
    }
    pdf_button = tk.Button(historie_window, text="PDF generieren", command=generiere_pdf, **pdf_btn_style)
    pdf_button.pack(anchor="w", padx=10, pady=5)
    pdf_button.bind("<Enter>", button_shape)
    pdf_button.bind("<Leave>", button_reset)

def zeige_firma_bewerbungen(window, firma_name):
    # Funktion, um das Fenster zu leeren und die Firmenübersicht neu zu laden
    def zurueck_zu_firmen():
        for widget in window.winfo_children():
            widget.destroy()
        zeige_historie_fenster(window)

    # Clear existing content in the window
    for widget in window.winfo_children():
        widget.destroy()

    # Back button to return to the company list
    back_btn_style = {
        "font": ("Helvetica", 12, "bold"),
        "fg": "white",
        "bg": "#4682b4",  # Mittelblau
        "padx": 20,
        "pady": 10,
        "relief": "flat",
        "highlightthickness": 0,
        "bd": 0
    }
    back_button = tk.Button(window, text="Zurück", command=zurueck_zu_firmen, **back_btn_style)
    back_button.pack(anchor="w", padx=10, pady=5)
    back_button.bind("<Enter>", button_shape)
    back_button.bind("<Leave>", button_reset)

    # Display the selected company name at the top
    title_label = tk.Label(window, text=f"Bewerbungen für {firma_name}", font=("Helvetica", 14, "bold"), bg="#d0f0f0")
    title_label.pack(anchor="w", padx=10, pady=5)

    # Query and display all applications for the selected company
    conn = get_db_connection()
    c = conn.cursor()
    c.execute('SELECT betreff, nachricht, datum FROM bewerbungen WHERE firma=?', (firma_name,))
    resultate = c.fetchall()
    conn.close()

    for betreff, nachricht, datum in resultate:
        betreff_label = tk.Label(window, text=f"Betreff: {betreff}", font=("Helvetica", 12, "bold"), bg="#d0f0f0")
        betreff_label.pack(anchor="w", padx=10, pady=2)

        nachricht_text = tk.Text(window, height=5, width=60, wrap="word", font=("Helvetica", 12), bg="#f0f8ff", relief="solid", padx=5, pady=5)
        nachricht_text.insert(tk.END, nachricht)
        nachricht_text.config(state="disabled")
        nachricht_text.pack(anchor="w", padx=10, pady=5)

def button_shape(event):
    event.widget.config(highlightbackground='#FFFFFF', highlightthickness=2, padx=20, pady=10, relief='flat')

def button_reset(event):
    event.widget.config(highlightthickness=0, padx=20, pady=10, relief='flat')

# Ensure to create table before app starts
create_table()

app = tk.Tk()
app.title("E-Mail Bewerbungsassistent")
app.configure(bg="#d0f0f0")  # Light turquoise background
app.update_idletasks()

original_width = 760
original_height = 710
new_height = int(original_height * 1.0)
app.geometry(f"{original_width}x{new_height}")

# Berechne die Position, um das Fenster in der Mitte des Bildschirms zu öffnen
app.update_idletasks()
screen_width = app.winfo_screenwidth()
screen_height = app.winfo_screenheight()
x = (screen_width // 2) - (original_width // 2)
y = (screen_height // 2) - (new_height // 2)
app.geometry(f"{original_width}x{new_height}+{x}+{y}")

frame = tk.Frame(app, padx=10, pady=10, bg="#d0f0f0")
frame.grid(row=0, column=0, sticky="nsew")

# Styling dictionaries
style = {
    "font": ("Helvetica", 12),
    "padx": 10,
    "pady": 5,
    "bg": "#d0f0f0"
}

entry_style = {
    "font": ("Helvetica", 12),
    "bg": "#4682b4",  # Medium blue
    "fg": "white"
}

btn_style = {
    "font": ("Helvetica", 12, "bold"),
    "fg": "white",
    "bg": "#4caf50",  # Change this to the desired color
    "padx": 20,
    "pady": 10,
    "relief": "flat",
    "highlightthickness": 0,
    "bd": 0
}

# Input fields and labels
tk.Label(frame, text="Art der E-Mail:", **style).grid(row=0, column=0, sticky="w")
art_var = tk.StringVar(value="Bewerbung")
tk.Radiobutton(frame, text="Bewerbung", variable=art_var, value="Bewerbung", **style).grid(row=0, column=1, sticky="w")
tk.Radiobutton(frame, text="Anfrage", variable=art_var, value="Anfrage", **style).grid(row=0, column=2, sticky="w")

tk.Label(frame, text="Dein Name:", **style).grid(row=1, column=0, sticky="w")
name_entry = tk.Entry(frame, width=60, **entry_style)
name_entry.grid(row=1, column=1, columnspan=2)

tk.Label(frame, text="Tel.:", **style).grid(row=2, column=0, sticky="w")
telefon_entry = tk.Entry(frame, width=60, **entry_style)
telefon_entry.grid(row=2, column=1, columnspan=2)

tk.Label(frame, text="Anrede:", **style).grid(row=3, column=0, sticky="w")
anrede_var = tk.StringVar(value="Herr")
tk.Radiobutton(frame, text="Herr", variable=anrede_var, value="Herr", **style).grid(row=3, column=1, sticky="w")
tk.Radiobutton(frame, text="Frau", variable=anrede_var, value="Frau", **style).grid(row=3, column=2, sticky="w")

tk.Label(frame, text="Ansprechpartner:", **style).grid(row=4, column=0, sticky="w")
ansprechpartner_entry = tk.Entry(frame, width=60, **entry_style)
ansprechpartner_entry.grid(row=4, column=1, columnspan=2)

tk.Label(frame, text="Beruf:", **style).grid(row=5, column=0, sticky="w")
beruf_var = tk.StringVar(value="Fachinformatiker Systemintegration")
beruf_menu = tk.OptionMenu(frame, beruf_var, "Fachinformatiker Systemintegration", "Fachinformatiker Anwendungsentwicklung")
beruf_menu.configure(bg="white", font=("Helvetica", 12), padx=5)
beruf_menu.grid(row=5, column=1, columnspan=2, sticky="w")

tk.Label(frame, text="Firma:", **style).grid(row=6, column=0, sticky="w")
firma_entry = tk.Entry(frame, width=60, **entry_style)
firma_entry.grid(row=6, column=1, columnspan=2)

tk.Label(frame, text="Datum & Uhrzeit:", **style).grid(row=7, column=0, sticky="w")
datum_entry = tk.Entry(frame, width=60, **entry_style)
datum_entry.grid(row=7, column=1, columnspan=2)
datum_entry.config(state="disabled")  # Make entry read-only

# Action buttons
button = tk.Button(frame, text="E-Mail generieren", command=zeige_bewerbung, **btn_style)
button.grid(row=8, column=0, columnspan=3, pady=10)
button.bind("<Enter>", button_shape)
button.bind("<Leave>", button_reset)

historie_button = tk.Button(frame, text="Historie anzeigen", command=zeige_historie_fenster, **btn_style)
historie_button.grid(row=9, column=0, columnspan=2, pady=10)
historie_button.bind("<Enter>", button_shape)
historie_button.bind("<Leave>", button_reset)

outlook_button = tk.Button(frame, text="In Outlook öffnen", command=oeffne_in_outlook, **btn_style)
outlook_button.grid(row=9, column=1, columnspan=2, pady=10)
outlook_button.bind("<Enter>", button_shape)
outlook_button.bind("<Leave>", button_reset)

# Result display area with scrollbar
result_text = tk.Text(frame, height=15, width=80, wrap="word", padx=5, pady=5)
result_text.grid(row=10, column=0, columnspan=3, pady=10)
scrollbar = tk.Scrollbar(frame, command=result_text.yview)
scrollbar.grid(row=10, column=3, sticky='nsew')
result_text['yscrollcommand'] = scrollbar.set

# Verbindung bei Programmende schließen
def close_db_connection():
    try:
        conn = get_db_connection()
        conn.close()
    except sqlite3.Error as e:
        messagebox.showerror("Fehler", f"Fehler beim Schließen der Datenbankverbindung: {e}")

# Registrierung des Schließens beim Programmende
atexit.register(close_db_connection)

# Rufe die Funktion auf, um die Tabelle zu erstellen, falls sie noch nicht existiert
create_table()

app.mainloop()
