import React, { useState } from 'react';
import './App.css';
import Form from './components/Form';
import History from './components/History';
import TextEditor from './components/TextEditor';

function App() {
  const [applications, setApplications] = useState([]);
  const [motivationsschreiben, setMotivationsschreiben] = useState('');

  const handleApplicationSubmit = (newApplication) => {
    setApplications([...applications, newApplication]);
  };

  const handleMotivationsschreibenChange = (value) => {
    setMotivationsschreiben(value);
  };

  return (
    <div className="App">
      <h1>Bewerbungsgenerator</h1>
      <Form onSubmit={handleApplicationSubmit} />
      <TextEditor value={motivationsschreiben} onChange={handleMotivationsschreibenChange} />
      <History applications={applications} />
    </div>
  );
}

export default App;
