function Form({ onSubmit }) {
  const [formData, setFormData] = useState({
    name: '',
    company: '',
    position: '',
    motivationsschreiben: '',
  });

  const handleChange = (event) => {
    setFormData({
      ...formData,
      [event.target.name]: event.target.value,
    });
  };

  const handleSubmit = (event) => {
    event.preventDefault();
    onSubmit(formData);
    setFormData({
      name: '',
      company: '',
      position: '',
      motivationsschreiben: '',
    });
  };

  return (
    <form onSubmit={handleSubmit}>
      <label>
        Name:
        <input type="text" name="name" value={formData.name} onChange={handleChange} />
      </label>
      <label>
        Firma:
        <input type="text" name="company" value={formData.company} onChange={handleChange} />
      </label>
      <label>
        Position:
        <input type="text" name="position" value={formData.position} onChange={handleChange} />
      </label>
      <label>
        Motivationsschreiben:
        <textarea name="motivationsschreiben" value={formData.motivationsschreiben} onChange={handleChange} />
      </label>
      <button type="submit">Absenden</button>
    </form>
  );
}
from django import forms
from .models import Bewerbung

class BewerbungsForm(forms.ModelForm):
    class Meta:
        model = Bewerbung
        fields = '__all__'  # Passe die Felder an, falls nötig

export default Form;
