from rest_framework import serializers
from myapp.models import Bewerbung

class BewerbungSerializer(serializers.ModelSerializer):
    class Meta:
        model = Bewerbung
        fields = '__all__'  # Oder gib explizit die Felder an, die serialisiert werden sollen

# settings.py
INSTALLED_APPS = [
    # ... other apps
    'rest_framework',
    'bewerbungen',  # Ersetze 'bewerbungen' durch den Namen deiner App
]
class BewerbungSerializer(serializers.ModelSerializer):
    class Meta:
        model = Bewerbung
        fields = ['id', 'name', 'firma', 'position', 'motivationsschreiben']  # Explizite Angabe der Felder
        extra_kwargs = {
            'name': {'write_only': True},  # Name nur beim Erstellen, nicht beim Aktualisieren
            'motivationsschreiben': {'required': True}  # Pflichtfeld
        }
