import customtkinter as ctk
from tkinter import messagebox
import sqlite3
import os
import win32com.client as win32
import gender_guesser.detector as gender
from datetime import datetime
from fpdf import FPDF

# Datenbank-Verbindung
conn = sqlite3.connect('bewerbungen.db')
c = conn.cursor()

# Add the date column if it doesn’t exist
try:
    c.execute('ALTER TABLE bewerbungen ADD COLUMN date TEXT')
    conn.commit()
except sqlite3.OperationalError:
    # Ignore the error if the date column already exists
    pass

# Erstelle Tabelle, falls nicht vorhanden
c.execute('''
    CREATE TABLE IF NOT EXISTS bewerbungen (
        id INTEGER PRIMARY KEY,
        art TEXT,
        name TEXT,
        praktikum TEXT,
        firma TEXT,
        telefon TEXT,
        anrede TEXT,
        ansprechpartner TEXT,
        betreff TEXT,
        nachricht TEXT,
        date TEXT
    )
''')
conn.commit()

# Gender detector instance
d = gender.Detector()

# Funktion zur Bestimmung der Anrede basierend auf dem Vornamen
def determine_anrede(ansprechpartner):
    gender_result = d.get_gender(ansprechpartner.split()[0])
    if gender_result in ['male', 'mostly_male']:
        return 'Sehr geehrter Herr'
    elif gender_result in ['female', 'mostly_female']:
        return 'Sehr geehrte Frau'
    else:
        return 'Sehr geehrte/r'

def speichere_bewerbung(art, name, praktikum, firma, telefon, anrede, ansprechpartner, betreff, nachricht):
    datum = datetime.now().strftime("%Y-%m-%d %H:%M:%S")  # aktuelles Datum und Uhrzeit
    c.execute('''
        INSERT INTO bewerbungen (art, name, praktikum, firma, telefon, anrede, ansprechpartner, betreff, nachricht, date)
        VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
    ''', (art, name, praktikum, firma, telefon, anrede, ansprechpartner, betreff, nachricht, datum))
    conn.commit()


def generiere_bewerbung(art, name, praktikum, firma, telefon, anrede, ansprechpartner):
    # Bestimmung der Anrede basierend auf dem Namen des Ansprechpartners
    anrede = determine_anrede(ansprechpartner)

    if art == "Bewerbung":
        betreff = "Bewerbung für ein Praktikum"
        nachricht = (
            f"{anrede} {ansprechpartner},\n\n"
            f"ich bin {name} und mache eine Umschulung im Bereich {praktikum}. "
            f"Mit großem Interesse habe ich von den spannenden Projekten und den "
            f"innovativen Ansätzen Ihres Unternehmens {firma} gehört. "
            f"Ich bin überzeugt, dass ein Praktikum bei Ihnen eine hervorragende Möglichkeit wäre, "
            f"praktische Erfahrungen zu sammeln und meine Kenntnisse zu vertiefen.\n\n"
            f"Im Rahmen meiner Umschulung habe ich bereits umfangreiche theoretische Kenntnisse erworben und "
            f"möchte diese nun durch praktische Erfahrungen ergänzen. Ihr Unternehmen bietet hierfür die ideale "
            f"Plattform, da es für seine herausragende Innovationskraft und sein angenehmes Arbeitsklima bekannt ist.\n\n"
            f"Über eine Einladung zu einem persönlichen Gespräch würde ich mich sehr freuen.\n\n"
            f"Mit freundlichen Grüßen,\n"
            f"{name}\n"
            f"Tel.: {telefon}"
        )
    elif art == "Anfrage":
        betreff = "Anfrage auf ein Praktikum"
        nachricht = (
            f"{anrede} {ansprechpartner},\n\n"
            f"mein Name ist {name} und ich mache eine Umschulung im Bereich {praktikum}. "
            f"Ich interessiere mich sehr für ein Praktikum bei Ihrem Unternehmen {firma}. "
            f"Ich würde gerne mehr über die Möglichkeiten und Rahmenbedingungen für ein Praktikum in Ihrem Hause erfahren.\n\n"
            f"Da Ihr Unternehmen für seine innovativen Projekte und sein dynamisches Team bekannt ist, bin ich überzeugt, dass "
            f"ich bei Ihnen wertvolle Erfahrungen sammeln und mein Wissen erweitern kann.\n\n"
            f"Über eine positive Rückmeldung würde ich mich sehr freuen.\n\n"
            f"Mit freundlichen Grüßen,\n"
            f"{name}\n"
            f"Tel.: {telefon}"
        )
    else:
        messagebox.showerror("Fehler", "Ungültige Option.")
        return None, None

    return betreff, nachricht

def speichere_bewerbung_als_pdf():
    # Erstelle ein PDF-Dokument
    pdf = FPDF()
    pdf.set_auto_page_break(auto=True, margin=15)
    pdf.add_page()

    # Setze die Schriftart auf Arial, Größe 12
    pdf.set_font('Arial', size=12)

    # Hole den Text aus dem Textfeld
    text = result_text.get("1.0", "end-1c")  # Entfernt das letzte Leerzeichen

    # Füge den Text zum PDF hinzu
    pdf.multi_cell(0, 10, text)

    # Speicher das PDF unter einem bestimmten Namen
    file_path = "bewerbung.pdf"
    pdf.output(file_path)

    # Bestätigungsnachricht
    messagebox.showinfo("PDF gespeichert", f"Die Bewerbung wurde als PDF gespeichert: {file_path}")    
    
def zeige_bewerbung():
    art = art_var.get()
    name = name_entry.get()
    praktikum = beruf_var.get()
    firma = firma_entry.get()
    telefon = telefon_entry.get()
    ansprechpartner = ansprechpartner_entry.get()

# Bestimmung der Anrede basierend auf dem Namen des Ansprechpartners
    anrede = determine_anrede(ansprechpartner)
    betreff, nachricht = generiere_bewerbung(art, name, praktikum, firma, telefon, anrede, ansprechpartner)

    if betreff and nachricht:
        result_text.delete("1.0", "end")
        result_text.insert("end", f"Betreff: {betreff}\n\n{nachricht}")
        speichere_bewerbung(art, name, praktikum, firma, telefon, anrede, ansprechpartner, betreff, nachricht)

def zeige_historie_fenster():
    historie_window = ctk.CTkToplevel(app)
    historie_window.title("Bewerbungshistorie")
    historie_window.geometry("600x500")
    historie_window.configure(fg_color="#e6f0fa")

    # Center the window and keep it on top
    historie_window.transient(app)
    historie_window.grab_set()
    historie_window.attributes("-topmost", True)
    historie_window.update_idletasks()

    window_width, window_height = 600, 500
    screen_width, screen_height = historie_window.winfo_screenwidth(), historie_window.winfo_screenheight()
    position_top = int(screen_height / 2 - window_height / 2)
    position_right = int(screen_width / 2 - window_width / 2)
    historie_window.geometry(f"{window_width}x{window_height}+{position_right}+{position_top}")

    # Create a canvas for scrolling
    canvas = ctk.CTkCanvas(historie_window, width=580, height=450, bg="#e6f0fa")
    canvas.pack(side="left", fill="both", expand=True)

    # Add a scrollbar to the canvas
    scrollbar = ctk.CTkScrollbar(historie_window, command=canvas.yview)
    scrollbar.pack(side="right", fill="y")
    canvas.configure(yscrollcommand=scrollbar.set)

    # Create a frame inside the canvas
    scrollable_frame = ctk.CTkFrame(canvas, fg_color="#e6f0fa")
    canvas.create_window((0, 0), window=scrollable_frame, anchor="nw")

    # Load Bewerbungen data and display them
    c.execute('SELECT id, art, firma, date FROM bewerbungen')
    bewerbungen = c.fetchall()

    for bewerbung in bewerbungen:
        bewerbung_id, art, firma, datum = bewerbung
        button_text = f"{datum} - {art} - {firma}"

        bewerbung_button = ctk.CTkButton(
            scrollable_frame,
            text=button_text,
            font=("Helvetica", 14),
            command=lambda bid=bewerbung_id: zeige_firma_bewerbungen(historie_window, bid)
        )
        bewerbung_button.pack(anchor="w", padx=15, pady=8)

    # Configure scrolling
    scrollable_frame.update_idletasks()
    canvas.config(scrollregion=canvas.bbox("all"))

    # Mouse scrolling support
    def on_mouse_wheel(event):
        # Scroll by a certain amount depending on the direction of the scroll wheel
        canvas.yview_scroll(int(-1*(event.delta/120)), "units")

    # Bind mouse wheel to scroll event
    canvas.bind_all("<MouseWheel>", on_mouse_wheel)



def zeige_firma_bewerbungen(window, bewerbung_id):
    for widget in window.winfo_children():
        widget.destroy()

    c.execute('SELECT betreff, nachricht, firma FROM bewerbungen WHERE id=?', (bewerbung_id,))
    result = c.fetchone()

    if result:
        betreff, nachricht, firma_name = result
        title_label = ctk.CTkLabel(window, text=f"Bewerbung für {firma_name}", font=("Helvetica", 16, "bold"))
        title_label.pack(anchor="w", padx=15, pady=8)

        betreff_label = ctk.CTkLabel(window, text=f"Betreff: {betreff}", font=("Helvetica", 14, "bold"))
        betreff_label.pack(anchor="w", padx=15, pady=5)

        nachricht_text = ctk.CTkTextbox(window, height=350, width=600, wrap="word", padx=10, pady=10)
        nachricht_text.insert("end", nachricht)
        nachricht_text.configure(state="disabled")
        nachricht_text.pack(anchor="w", padx=15, pady=5)


def oeffne_in_outlook():
    betreff = result_text.get("1.0", "end").split("\n")[1]
    nachricht = "\n".join(result_text.get("1.0", "end").split("\n")[2:])
    outlook = win32.Dispatch('outlook.application')
    mail = outlook.CreateItem(0)
    mail.Subject = betreff
    mail.Body = nachricht
    mail.Display()

app = ctk.CTk()
app.title("E-Mail Bewerbungsassistent")
app.geometry("690x730")
app.configure(fg_color="#e6f0fa")

# Fenster zentrieren
window_width = 690
window_height = 780
screen_width = app.winfo_screenwidth()
screen_height = app.winfo_screenheight()
position_top = int(screen_height / 2 - window_height / 2)
position_right = int(screen_width / 2 - window_width / 2)
app.geometry(f'{window_width}x{window_height}+{position_right}+{position_top}')

frame = ctk.CTkFrame(app, corner_radius=10)
frame.grid(row=0, column=0, sticky="nsew", padx=25, pady=25)

# Restlicher Code für UI-Elemente bleibt unverändert
art_var = ctk.StringVar(value="Bewerbung")
ctk.CTkLabel(frame, text="Art der E-Mail:", font=("Helvetica", 16)).grid(row=0, column=0, sticky="w")
ctk.CTkRadioButton(frame, text="Bewerbung", variable=art_var, value="Bewerbung", font=("Helvetica", 14)).grid(row=0, column=1, sticky="w")
ctk.CTkRadioButton(frame, text="Anfrage", variable=art_var, value="Anfrage", font=("Helvetica", 14)).grid(row=0, column=2, sticky="w")

ctk.CTkLabel(frame, text="Dein Name:", font=("Helvetica", 16)).grid(row=1, column=0, sticky="w")
name_entry = ctk.CTkEntry(frame, width=450, font=("Helvetica", 14))
name_entry.grid(row=1, column=1, columnspan=2)

ctk.CTkLabel(frame, text="Tel.:", font=("Helvetica", 16)).grid(row=2, column=0, sticky="w")
telefon_entry = ctk.CTkEntry(frame, width=450, font=("Helvetica", 14))
telefon_entry.grid(row=2, column=1, columnspan=2)

ctk.CTkLabel(frame, text="Praktikum im Bereich:", font=("Helvetica", 16)).grid(row=3, column=0, sticky="w", pady=(20, 0))
beruf_var = ctk.StringVar(value="Fachinformatiker für Anwendungsentwicklung")
ctk.CTkOptionMenu(frame, variable=beruf_var, values=["Fachinformatiker für Anwendungsentwicklung", "Fachinformatiker für Systemintegration"], font=("Helvetica", 14)).grid(row=3, column=1, columnspan=2)

ctk.CTkLabel(frame, text="Firma:", font=("Helvetica", 16)).grid(row=4, column=0, sticky="w", pady=(10, 0))
firma_entry = ctk.CTkEntry(frame, width=450, font=("Helvetica", 14))
firma_entry.grid(row=4, column=1, columnspan=2)

ctk.CTkLabel(frame, text="Ansprechpartner:", font=("Helvetica", 16)).grid(row=5, column=0, sticky="w", pady=(10, 0))
ansprechpartner_entry = ctk.CTkEntry(frame, width=450, font=("Helvetica", 14))
ansprechpartner_entry.grid(row=5, column=1, columnspan=2)

result_text = ctk.CTkTextbox(frame, height=300, width=600, wrap="word", font=("Helvetica", 12), padx=10, pady=10)
result_text.grid(row=6, column=0, columnspan=3, padx=20, pady=20)

speichern_button = ctk.CTkButton(frame, text="Bewerbung generieren und speichern", font=("Helvetica", 14), command=zeige_bewerbung)
speichern_button.grid(row=7, column=0, columnspan=3, pady=10)

historie_button = ctk.CTkButton(frame, text="Bewerbungshistorie", font=("Helvetica", 14), command=zeige_historie_fenster)
historie_button.grid(row=8, column=0, columnspan=3, pady=10)

outlook_button = ctk.CTkButton(frame, text="In Outlook öffnen", font=("Helvetica", 14), command=oeffne_in_outlook)
outlook_button.grid(row=9, column=0, columnspan=3, pady=10)

pdf_button = ctk.CTkButton(frame, text="Bewerbung als PDF speichern", font=("Helvetica", 14), command=speichere_bewerbung_als_pdf)
pdf_button.grid(row=10, column=0, columnspan=3, pady=10)


app.mainloop()
