import tkinter as tk
from tkinter import ttk, messagebox, StringVar, Text, DISABLED, NORMAL
import sqlite3
from datetime import datetime
from fpdf import FPDF
import customtkinter as ctk
import time
from spellchecker import SpellChecker
import tkinter as tk
from tkinter import messagebox
import openai
# Adapter und Konverter für datetime
sqlite3.register_adapter(datetime, lambda d: d.isoformat())
sqlite3.register_converter("DATETIME", lambda s: datetime.fromisoformat(s.decode("utf-8")))

# OpenAI-API-Schlüssel (initial leer)
api_key = ""

# Funktion zum Speichern des API-Schlüssels
def save_api_key():
    global api_key
    key = api_key_entry.get()
    if key.strip():
        api_key = key.strip()
        openai.api_key = api_key
        messagebox.showinfo("Erfolg", "API-Schlüssel wurde gespeichert!")
        login_window.destroy()
    else:
        messagebox.showerror("Fehler", "Bitte einen gültigen API-Schlüssel eingeben.")

# Funktion zur Erstellung des Login-Fensters
def show_login_window():
    global api_key_entry, login_window
    login_window = tk.Tk()
    login_window.title("Login für OpenAI")
    login_window.geometry("400x200")
    login_window.resizable(False, False)

    tk.Label(login_window, text="OpenAI API-Schlüssel", font=("Helvetica", 12)).pack(pady=10)
    api_key_entry = tk.Entry(login_window, width=40, font=("Helvetica", 12), show="*")
    api_key_entry.pack(pady=10)

    tk.Button(login_window, text="Speichern", font=("Helvetica", 12), command=save_api_key).pack(pady=10)

    tk.Label(login_window, text="Erhalte deinen Schlüssel unter https://platform.openai.com", font=("Helvetica", 10), fg="blue").pack(pady=10)

    login_window.mainloop()

import openai  # KI-Integration hinzufügen

# OpenAI-API-Key konfigurieren (ersetze mit deinem eigenen API-Key)
openai.api_key = "DEIN_API_KEY_HIER"

# Funktion zur KI-Textgenerierung
def generiere_ki_text(name, praktikum, firma, ansprechpartner):
    try:
        anrede = determine_anrede(ansprechpartner)
        prompt = (
            f"Erstelle ein Bewerbungsschreiben für eine Person namens {name}, "
            f"die eine Umschulung im Bereich {praktikum} macht. Die Bewerbung "
            f"soll an die Firma {firma} gerichtet sein und den Ansprechpartner {ansprechpartner} ansprechen."
        )
        
        response = openai.Completion.create(
            engine="text-davinci-003",  # GPT-3-Modell
            prompt=prompt,
            max_tokens=300,
            temperature=0.7
        )
        text = response.choices[0].text.strip()
        return f"{anrede} {ansprechpartner},\n\n{text}\n\nMit freundlichen Grüßen,\n{name}"
    except Exception as e:
        messagebox.showerror("Fehler", f"Fehler bei der KI-Textgenerierung: {e}")
        return ""




# Hauptfenster
app = tk.Tk()
app.title("OpenAI Login Integration")
app.geometry()

# Login-Button
tk.Button(app, text="Login für OpenAI", font=("Helvetica", 12), command=show_login_window).pack(pady=20)



# Deutsches Wörterbuch laden
spell = SpellChecker(language='de')


# Ladebildschirm-Funktion
def ladebildschirm():
    root = tk.Tk()
    root.title("Ladebildschirm")
    root.geometry()
    root.configure(bg="#2E2E2E")  # Dunkelgrauer Hintergrund


    # Lade-Label
    lade_label = tk.Label(root, text="Wird geladen...", font=("Helvetica", 16), fg="white", bg="#2E2E2E")
    lade_label.pack(pady=40)  # Abstand zum Ladebalken


    # Ladebalken
    ladebalken = ttk.Progressbar(root, orient="horizontal", length=400, mode="determinate", maximum=100)
    ladebalken.pack(pady=20)  # Abstand zum Text


    # Lade-Logik
    def lade():
        for i in range(101):
            time.sleep(0.03)  # Wartezeit simulieren
            ladebalken["value"] = i
            root.update_idletasks()  # Updates das UI
        root.destroy()  # Schließt das Fenster nach dem Laden


    root.after(100, lade)  # Starte die Ladeanimation nach 100ms
    root.mainloop()

# Ladebildschirm anzeigen, bevor das Hauptprogramm startet
ladebildschirm()

# Datenbank-Verbindung
conn = sqlite3.connect('bewerbungen.db')
c = conn.cursor()

# Erstelle Tabelle, falls sie nicht vorhanden ist
c.execute('''
    CREATE TABLE IF NOT EXISTS bewerbungen (
        id INTEGER PRIMARY KEY,
        art TEXT,
        name TEXT,
        praktikum TEXT,
        firma TEXT,
        telefon TEXT,
        anrede TEXT,
        ansprechpartner TEXT,
        betreff TEXT,
        nachricht TEXT,
        date TEXT
    )
''')
conn.commit()

# Autokorrektur: Wörter markieren
def autokorrektur_markieren(event, text_widget):
    text_widget.tag_remove("falsch", "1.0", "end")  # Entfernt alte Markierungen
    text = text_widget.get("1.0", "end-1c")  # Gesamten Text abrufen
    worte = text.split()  # Text in Wörter aufteilen

    for wort in worte:
        if wort not in spell and spell.candidates(wort):  # Wort ist falsch geschrieben
            start_index = text_widget.search(wort, "1.0", stopindex="end")
            if start_index:
                end_index = f"{start_index}+{len(wort)}c"
                text_widget.tag_add("falsch", start_index, end_index)  # Markiere das Wort
                text_widget.tag_config("falsch", foreground="red")  # Rot markieren

# Korrektur-Button: Falsche Wörter korrigieren
def korrigieren(text_widget):
    text = text_widget.get("1.0", "end-1c")
    worte = text.split()

    for wort in worte:
        if wort not in spell and spell.candidates(wort):
            korrekturen = list(spell.candidates(wort))
            if korrekturen:
                korrektur = korrekturen[0]
                text = text.replace(wort, korrektur)

    text_widget.delete("1.0", "end")
    text_widget.insert("1.0", text)
# Funktion zur Bestimmung der Anrede (Dummy-Funktion, falls erforderlich)
def determine_anrede(ansprechpartner):
    """
    Automatische Gendererkennung basierend auf dem Namen des Ansprechpartners.
    """
    if not ansprechpartner.strip():
        return "Sehr geehrte Damen und Herren"
    
    anrede = "Sehr geehrte/r"
    
    # Typische Namensendungen für eine einfache Gendererkennung
    weibliche_endungen = ["a", "e", "ine", "ung", "heit", "keit", "in"]
    maennliche_endungen = ["er", "el", "us", "en", "on", "mann"]
    
    name_lower = ansprechpartner.strip().lower()
    
    if any(name_lower.endswith(endung) for endung in weibliche_endungen):
        anrede = "Sehr geehrte Frau"
    elif any(name_lower.endswith(endung) for endung in maennliche_endungen):
        anrede = "Sehr geehrter Herr"
    
    return anrede

# Funktion zur Anzeige und Speicherung der Bewerbung
def zeige_bewerbung():
    art = art_var.get()
    name = name_entry.get()
    praktikum = beruf_var.get()
    firma = firma_entry.get()
    telefon = telefon_entry.get()
    ansprechpartner = ansprechpartner_entry.get()
    if not name or not firma or not telefon:
        messagebox.showwarning("Eingabefehler", "Bitte alle Felder ausfüllen!")
        return
    anrede = determine_anrede(ansprechpartner)
    betreff = f"{art} für ein Praktikum"
    nachricht = result_text.get("1.0", "end-1c")
    now = datetime.now()
    
    result_text.delete("1.0", "end")
    result_text.insert("end", f"Betreff: {betreff}\n\n{nachricht}")
    c.execute('''
    INSERT INTO bewerbungen (art, name, praktikum, firma, telefon, anrede, ansprechpartner, betreff, nachricht, date)
    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
    ''', (art, name, praktikum, firma, telefon, anrede, ansprechpartner, betreff, nachricht, datetime.now()))

    conn.commit()
    
# Funktion zur PDF-Erstellung
def speichere_als_pdf(text):
    pdf = FPDF()
    pdf.add_page()
    pdf.set_font("Arial", size=12)
    pdf.multi_cell(0, 10, text)
    dateiname = f"bewerbung_{datetime.now().strftime('%Y%m%d_%H%M%S')}.pdf"
    pdf.output(dateiname)
    messagebox.showinfo("Erfolg", f"PDF wurde gespeichert als {dateiname}!")

# Funktion zur Anzeige der Bewerbungshistorie mit Scrollbar
def zeige_historie_fenster():
    # Lösche alle Widgets im aktuellen Frame
    for widget in frame.winfo_children():
        widget.destroy()



    # Listbox erstellen
    listbox = tk.Listbox(listbox_frame, font=("Helvetica", 12), yscrollcommand=scrollbar.set)
    listbox.pack(side="left", fill="both", expand=True)

    # Scrollbar erstellen
    scrollbar = tk.Scrollbar(listbox_frame, orient="vertical")
    scrollbar.pack(side="right", fill="y")

    # Datenbankabfrage für Historie
    c.execute('SELECT id, firma, date FROM bewerbungen ORDER BY date DESC')
    bewerbungen = c.fetchall()

    # Historieneinträge in die Listbox einfügen
    for b_id, firma, datum in bewerbungen:
        listbox.insert("end", f"{b_id}: {firma} - {datum}")

    # Detailanzeige bei Doppelklick
    def zeige_details(event):
        selected = listbox.curselection()
        if not selected:
            return
        index = selected[0]
        b_id = bewerbungen[index][0]  # ID des ausgewählten Eintrags

        # Detailabfrage
        c.execute('SELECT betreff, nachricht FROM bewerbungen WHERE id=?', (b_id,))
        result = c.fetchone()
        if result:
            betreff, nachricht = result
            messagebox.showinfo("Bewerbungsdetails", f"Betreff: {betreff}\n\n{nachricht}")

    # Doppelklick-Ereignis binden
    listbox.bind("<Double-1>", zeige_details)

    # Historieneinträge in die Listbox einfügen
    for b_id, firma, datum in bewerbungen:
        listbox.insert("end", f"{b_id}: {firma} - {datum}")

    global text_area
    text_area = Text(frame, height=20, width=60, wrap="word", padx=10, pady=10, font=("Helvetica", 12))
    text_area.pack(side="top", fill="both", expand=True)

    c.execute('SELECT id, firma, date FROM bewerbungen ORDER BY date DESC')
    bewerbungen = c.fetchall()

    for bewerbung_id, firma, datum in bewerbungen:
        button = ctk.CTkButton(listbox_frame, text=f"{firma} - {datum}",
                               command=lambda id=bewerbung_id: lade_bewerbung(id))
        button.pack(fill="x", pady=2)

    # Frame für die Buttons unterhalb des Textbereichs
    toolbar = ctk.CTkFrame(frame, fg_color="#e6f0fa")
    toolbar.pack(side="bottom", fill="x", padx=10, pady=10)



    # Button für Fett, Kursiv, Unterstrichen, Bewerbung, PDF mit gleicher Breite
    bold_button = ctk.CTkButton(toolbar, text="Fett", command=lambda: toggle_bold(text_area), width=15)
    bold_button.pack(side="left", padx=5)


    italic_button = ctk.CTkButton(toolbar, text="Kursiv", command=lambda: toggle_italic(text_area), width=15)
    italic_button.pack(side="left",fill="x", padx=5)


    underline_button = ctk.CTkButton(toolbar, text="Unterstrichen", command=lambda: toggle_underline(text_area), width=15)
    underline_button.pack(side="left", padx=5)


    pdf_button = ctk.CTkButton(toolbar, text="PDF", command=lambda: speichere_als_pdf(text_area.get("1.0", "end-1c")), width=15)
    pdf_button.pack(side="right", padx=5)
    
 # Bewerbung-Button im Historien-Frame (Start-Status: deaktiviert)
    global bewerbung_button
    bewerbung_button = ctk.CTkButton(toolbar, text="Bewerbung", font=("Helvetica", 14), state="disabled", command=lambda: zeige_bewerbung_inhalt(frame))
    bewerbung_button.pack(side="right", padx=5)
    
    # Detailabfrage
    c.execute('SELECT betreff, nachricht FROM bewerbungen WHERE id=?', (b_id,))
    result = c.fetchone()
    if result:
         betreff, nachricht = result
         messagebox.showinfo("Bewerbungsdetails", f"Betreff: {betreff}\n\n{nachricht}")

    # Doppelklick-Ereignis binden
    listbox.bind("<Double-1>", zeige_details)

def zeige_bewerbung_inhalt(parent_frame):
    # Verwende vorhandenen Frame
    buttons_frame = ctk.CTkFrame(parent_frame)  # Nutzt den übergebenen Frame
    buttons_frame.pack(side="left", padx=10, pady=10, fill="y")

    # Buttons hinzufügen
    deckblatt_button = ctk.CTkButton(buttons_frame, text="Deckblatt", font=("Helvetica", 14), command=lambda: show_content("Deckblatt"))
    deckblatt_button.pack(fill="x", pady=5)

    motivationsschreiben_button = ctk.CTkButton(buttons_frame, text="Motivationsschreiben", font=("Helvetica", 14), command=lambda: show_content("Motivationsschreiben"))
    motivationsschreiben_button.pack(fill="x", pady=5)

    lebenslauf_button = ctk.CTkButton(buttons_frame, text="Lebenslauf", font=("Helvetica", 14), command=lambda: show_content("Lebenslauf"))
    lebenslauf_button.pack(fill="x", pady=5)
   
    # Linksseitige Auswahlbuttons
    left_frame = ctk.CTkFrame(parent_frame, width=150)
    left_frame.pack(side="bottom", fill="y", padx=10, pady=10)


    # Rechter Frame zur Anzeige der Inhalte
    global text_area
    text_area = Text(frame, height=20, width=60, wrap="word", padx=10, pady=10, font=("Helvetica", 12))
    text_area.pack(side="right", fill="both", expand=True)

    # Buttons für die verschiedenen Dokumente
    buttons_frame = ctk.CTkFrame(frame)
    buttons_frame.pack(side="left", padx=10, pady=10, fill="y")

    # Funktion für die Anzeige der verschiedenen Dokumente
    def show_content(option):
        if option == "Deckblatt":
            content = f"Deckblatt für {name_entry.get()} - {firma_entry.get()}"
        elif option == "Motivationsschreiben":
            content = f"Motivationsschreiben von {name_entry.get()} - {firma_entry.get()}"
        else:
            content = f"Lebenslauf von {name_entry.get()} - {firma_entry.get()}"
        text_area_left.delete("1.0", "end")
        text_area_left.insert("1.0", content)

# Lade Bewerbung aus der Datenbank
def lade_bewerbung(bewerbung_id):
    c.execute('SELECT betreff, nachricht FROM bewerbungen WHERE id=?', (bewerbung_id,))
    result = c.fetchone()
    if result:
        betreff, nachricht = result
        text_area.configure(state="normal")
        text_area.delete("1.0", "end")
        text_area.insert("1.0", f"Betreff: {betreff}\n\n{nachricht}")
        text_area.configure(state="normal")
        bewerbung_button.configure(state="normal")  # Aktiviert den Bewerbung-Button, wenn ein Eintrag ausgewählt wurde

# Hauptfenster
app = ctk.CTk()
app.title("Bewerbungsassistent")
app.geometry()
app.configure(fg_color="#e6f0fa")

frame = ctk.CTkFrame(app, corner_radius=10)
frame.grid(row=0, column=0, sticky="nsew", padx=25, pady=25)

art_var = ctk.StringVar(value="Bewerbung")
ctk.CTkLabel(frame, text="Art der E-Mail:", font=("Helvetica", 16)).grid(row=0, column=0, sticky="w")
ctk.CTkRadioButton(frame, text="Bewerbung", variable=art_var, value="Bewerbung", font=("Helvetica", 14)).grid(row=0, column=1, sticky="w")
ctk.CTkRadioButton(frame, text="Anfrage", variable=art_var, value="Anfrage", font=("Helvetica", 14)).grid(row=0, column=2, sticky="w")

ctk.CTkLabel(frame, text="Dein Name:", font=("Helvetica", 16)).grid(row=1, column=0, sticky="w")
name_entry = ctk.CTkEntry(frame, width=450, font=("Helvetica", 14))
name_entry.grid(row=1, column=1, columnspan=2)

ctk.CTkLabel(frame, text="Tel.:", font=("Helvetica", 16)).grid(row=2, column=0, sticky="w")
telefon_entry = ctk.CTkEntry(frame, width=450, font=("Helvetica", 14))
telefon_entry.grid(row=2, column=1, columnspan=2)

ctk.CTkLabel(frame, text="Praktikum im Bereich:", font=("Helvetica", 16)).grid(row=3, column=0, sticky="w", pady=(20, 0))
beruf_var = ctk.StringVar(value="Fachinformatiker für Anwendungsentwicklung")
ctk.CTkOptionMenu(frame, variable=beruf_var, values=["Fachinformatiker für Anwendungsentwicklung", "Fachinformatiker für Systemintegration"], font=("Helvetica", 14)).grid(row=3, column=1, columnspan=2)

ctk.CTkLabel(frame, text="Firma:", font=("Helvetica", 16)).grid(row=4, column=0, sticky="w", pady=(10, 0))
firma_entry = ctk.CTkEntry(frame, width=450, font=("Helvetica", 14))
firma_entry.grid(row=4, column=1, columnspan=2)

ctk.CTkLabel(frame, text="Ansprechpartner:", font=("Helvetica", 16)).grid(row=5, column=0, sticky="w", pady=(10, 0))
ansprechpartner_entry = ctk.CTkEntry(frame, width=450, font=("Helvetica", 14))
ansprechpartner_entry.grid(row=5, column=1, columnspan=2)

result_text = Text(frame, height=20, width=60, wrap="word", font=("Helvetica", 12), padx=10, pady=10)
result_text.grid(row=6, column=0, columnspan=3, padx=20, pady=20)

# Autokorrektur während der Eingabe aktivieren
result_text.bind("<KeyRelease>", lambda event: autokorrektur_markieren(event, result_text))

speichern_button = ctk.CTkButton(frame, text="Bewerbung generieren und speichern", font=("Helvetica", 14), command=zeige_bewerbung)
speichern_button.grid(row=7, column=0, columnspan=3, pady=10)

historie_button = ctk.CTkButton(frame, text="Bewerbungshistorie", font=("Helvetica", 14), command=zeige_historie_fenster)
historie_button.grid(row=8, column=0, columnspan=3, pady=10)

korrigieren_button = ctk.CTkButton(frame, text="Korrigieren", font=("Helvetica", 14), command=lambda: korrigieren(result_text))
korrigieren_button.grid(row=9, column=0, columnspan=3, pady=10)


app.mainloop()
