import tkinter as tk
from tkinter import ttk, messagebox, StringVar, Text, DISABLED, NORMAL
import sqlite3
from datetime import datetime
from fpdf import FPDF
import customtkinter as ctk
import time
import tkinter as tk
from tkinter import messagebox
import openai
import tkinter as tk
import win32com.client
from tkinter import messagebox
# Liste aller Berufe in Deutschland direkt im Python-Code
berufe = [
    # A
    "Änderungsschneider/in", "Agrarservicefachkraft", "Altenpflegehelfer/in", "Altenpfleger/in",
    "Anästhesietechnische/r Assistent/in", "Anlagenmechaniker/in", 
    "Anlagenmechaniker/in für Sanitär-, Heizungs- und Klimatechnik", "Architekt/in", 
    "Arzthelfer/in", "Asphaltbauer/in", "Augenoptiker/in", "Ausbaufacharbeiter/in", 
    "Automatenfachmann/-frau", "Automobilkaufmann/-frau", "Automobilmechaniker/in",

    # B
    "Bäcker/in", "Bankkaufmann/-frau", "Baugeräteführer/in", "Baustoffprüfer/in",
    "Bauten- und Objektbeschichter/in", "Bauwerksabdichter/in", "Bauzeichner/in",
    "Behälter- und Apparatebauer/in", "Berufskraftfahrer/in", "Bestattungsfachkraft",
    "Beton- und Stahlbetonbauer/in", "Betonfertigteilbauer/in", "Binnenschiffer/in",
    "Biologielaborant/in", "Bodenleger/in", "Brauer/in und Mälzer/in", 
    "Buchbinder/in", "Buchhändler/in", "Büchsenmacher/in", "Bürokaufmann/-frau",

    # C
    "Chemielaborant/in", "Chemikant/in", "Chirurgiemechaniker/in",

    # D
    "Dachdecker/in", "Datenschutzbeauftragte/r", "Destillateur/in", "Drechsler/in", 
    "Drogist/in",

    # E
    "Edelmetallprüfer/in", "Edelsteinfasser/in", "Edelsteinschleifer/in",
    "Eisenbahner/in im Betriebsdienst", "Elektriker/in", 
    "Elektroniker/in für Automatisierungstechnik", "Elektroniker/in für Betriebstechnik", 
    "Elektroniker/in für Energie- und Gebäudetechnik", 
    "Elektroniker/in für Geräte und Systeme", 
    "Elektroniker/in für Informations- und Systemtechnik", 
    "Elektroniker/in für Maschinen und Antriebstechnik", 
    "Estrichleger/in", "Erzieher/in", "Eventmanager/in",

    # F
    "Fachangestellte/r für Arbeitsmarktdienstleistungen", "Fachangestellte/r für Bäderbetriebe",
    "Fachangestellte/r für Markt- und Sozialforschung", "Fachangestellte/r für Medien- und Informationsdienste",
    "Fachinformatiker/in für Anwendungsentwicklung", "Fachinformatiker/in für Systemintegration",
    "Fachkraft für Abwassertechnik", "Fachkraft für Agrarservice",
    "Fachkraft für Fruchtsafttechnik", "Fachkraft für Gastronomie", 
    "Fachkraft für Hafenlogistik", "Fachkraft für Holz- und Bautenschutzarbeiten",
    "Fachkraft für Kreislauf- und Abfallwirtschaft", "Fachkraft für Kurier-, Express- und Postdienstleistungen",
    "Fachkraft für Lagerlogistik", "Fachkraft für Lebensmitteltechnik",
    "Fachkraft für Metalltechnik", "Fachkraft für Rohr-, Kanal- und Industrieservice", 
    "Fahrzeuglackierer/in", "Feinoptiker/in", "Feinwerkmechaniker/in", 
    "Fleischer/in", "Florist/in", "Fluggerätmechaniker/in", 
    "Fluggerätelektroniker/in", "Fotograf/in", "Friseur/in", 

    # G
    "Gebäudereiniger/in", "Geigenbauer/in", "Geomatiker/in", 
    "Gießereimechaniker/in", "Glasbläser/in", "Glas- und Porzellanmaler/in", 
    "Glaser/in", "Goldschmied/in", "Graveur/in", "Gärtner/in",
    "Gestalter/in für visuelles Marketing",

    # H
    "Hauswirtschafter/in", "Hotelfachmann/-frau", "Holzblasinstrumentenmacher/in", 
    "Holzmechaniker/in", "Hörakustiker/in",

    # I
    "Immobilienkaufmann/-frau", "Industriemechaniker/in", "Industriekaufmann/-frau",
    "Informatikkaufmann/-frau", "Informationselektroniker/in", "IT-System-Elektroniker/in",

    # J
    "Juwelengoldschmied/in", "Juwelier/in",

    # K
    "Kaufmann/-frau für Büromanagement", "Kaufmann/-frau für Einzelhandel",
    "Kaufmann/-frau im E-Commerce", "Kaufmann/-frau für Spedition und Logistikdienstleistung",
    "Koch/Köchin", "Konditor/in", "Kosmetiker/in", "Kraftfahrzeugmechatroniker/in",

    # L
    "Landwirt/in", "Landschaftsgärtner/in", "Lacklaborant/in",

    # M
    "Maler/in und Lackierer/in", "Maurer/in", "Mechatroniker/in",
    "Mediengestalter/in Digital und Print", "Medizinische/r Fachangestellte/r",
    "Metallbauer/in", "Milchtechnologe/in",

    # N
    "Naturwerksteinmechaniker/in", "Notarfachangestellte/r",

    # O
    "Oberflächenbeschichter/in", "Orthopädietechniker/in",

    # P
    "Packmitteltechnologe/in", "Pferdewirt/in", "Pharmazeutisch-technische/r Assistent/in",
    "Pflegefachmann/-frau", "Physiklaborant/in",

    # R
    "Raumausstatter/in", "Restaurantfachmann/-frau", "Rohrleitungsbauer/in",

    # S
    "Sattler/in", "Schilder- und Lichtreklamehersteller/in", "Schlosser/in",
    "Schornsteinfeger/in", "Schreiner/in", "Sozialversicherungsfachangestellte/r",
    "Steuerfachangestellte/r", "Systemgastronom/in",

    # T
    "Tischler/in", "Tierpfleger/in", "Trockenbaumonteur/in",

    # U
    "Uhrmacher/in", "Umweltschutztechniker/in",

    # V
    "Verfahrensmechaniker/in für Kunststoff- und Kautschuktechnik",
    "Verpackungsmittelmechaniker/in", "Verkäufer/in",

    # W
    "Wasserbauer/in", "Weintechnologe/in", "Werkzeugmechaniker/in",
    "Winzer/in", "Wirtschaftsinformatiker/in",

    # Z
    "Zahntechniker/in", "Zerspanungsmechaniker/in", "Zimmerer/Zimmerin", 
    "Zweiradmechatroniker/in"
]

# OpenAI-API-Schlüssel (initial leer)
api_key = "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"

# Funktion zum Speichern des API-Schlüssels
def save_api_key():
    global api_key
    key = api_key_entry.get()
    if key.strip():
        api_key = key.strip()
        messagebox.showinfo("Erfolg", "API-Schlüssel wurde gespeichert!")
    else:
        messagebox.showerror("Fehler", "Bitte einen gültigen API-Schlüssel eingeben.")

# Funktion zum Fortsetzen des Programms
def weiter_und_schließen():
    if not api_key:
        messagebox.showerror("Fehler", "Bitte den API-Schlüssel eingeben, bevor Sie fortfahren!")
        return
    login_window.destroy()
    start_main_program()

# Hauptprogramm nach Login

# Funktion zur Textgenerierung mit OpenAI
def generiere_ki_text_mit_openai(name, praktikum, firma, ansprechpartner):
    if not api_key:
        messagebox.showerror("Fehler", "Bitte logge dich zuerst ein und speichere deinen API-Schlüssel.")
        return ""

    try:
        prompt = (
            f"Erstelle ein professionelles Bewerbungsschreiben für ein Praktikum. "
            f"Der Name des Bewerbers ist {name}. Der Praktikumsbereich ist {praktikum}. "
            f"Die Bewerbung richtet sich an die Firma {firma} und den Ansprechpartner {ansprechpartner}."
        )
        response = openai.Completion.create(
            engine="text-davinci-003",
            prompt=prompt,
            max_tokens=500,
            temperature=0.7
        )
        return response.choices[0].text.strip()
    except Exception as e:
        messagebox.showerror("Fehler", f"KI-Generierung fehlgeschlagen: {e}")
        return ""

# Ladebildschirm-Funktion
def ladebildschirm():
    root = tk.Tk()
    root.title("Ladebildschirm")
    root.geometry()
    root.configure(bg="#2E2E2E")  # Dunkelgrauer Hintergrund

    # Lade-Label
    lade_label = tk.Label(root, text="Wird geladen...", font=("Helvetica", 16), fg="white", bg="#2E2E2E")
    lade_label.pack(pady=40)  # Abstand zum Ladebalken

    # Ladebalken
    ladebalken = ttk.Progressbar(root, orient="horizontal", length=400, mode="determinate", maximum=100)
    ladebalken.pack(pady=20)  # Abstand zum Text

    # Lade-Logik
    def lade():
        for i in range(101):
            time.sleep(0.03)  # Wartezeit simulieren
            ladebalken["value"] = i
            root.update_idletasks()  # Updates das UI
        root.destroy()  # Schließt das Fenster nach dem Laden

    root.after(100, lade)  # Starte die Ladeanimation nach 100ms
    root.mainloop()

# Ladebildschirm anzeigen, bevor das Hauptprogramm startet
ladebildschirm()

# Datenbank-Verbindung
conn = sqlite3.connect('bewerbungen.db')
c = conn.cursor()

# Erstelle Tabelle, falls sie nicht vorhanden ist
c.execute('''
    CREATE TABLE IF NOT EXISTS bewerbungen (
        id INTEGER PRIMARY KEY,
        art TEXT,
        name TEXT,
        praktikum TEXT,
        firma TEXT,
        telefon TEXT,
        anrede TEXT,
        ansprechpartner TEXT,
        betreff TEXT,
        nachricht TEXT,
        date TEXT
    )
''')
conn.commit()

# Funktion zur Bestimmung der Anrede (Dummy-Funktion, falls erforderlich)
def determine_anrede(ansprechpartner):
    """
    Automatische Gendererkennung basierend auf dem Namen des Ansprechpartners.
    """
    if not ansprechpartner.strip():
        return "Sehr geehrte Damen und Herren"
    
    anrede = "Sehr geehrte/r"
    
    # Typische Namensendungen für eine einfache Gendererkennung
    weibliche_endungen = ["a", "e", "ine", "ung", "heit", "keit", "in"]
    maennliche_endungen = ["er", "el", "us", "en", "on", "mann"]
    
    name_lower = ansprechpartner.strip().lower()
    
    if any(name_lower.endswith(endung) for endung in weibliche_endungen):
        anrede = "Sehr geehrte Frau"
    elif any(name_lower.endswith(endung) for endung in maennliche_endungen):
        anrede = "Sehr geehrter Herr"
    
    return anrede

def zeige_bewerbung():
    art = art_var.get()
    name = name_entry.get()
    praktikum = beruf_var.get()  # Beruf aus dem Dropdown
    firma = firma_entry.get()
    telefon = telefon_entry.get()
    ansprechpartner = ansprechpartner_entry.get()
    if not name or not firma or not telefon:
        messagebox.showwarning("Eingabefehler", "Bitte alle Felder ausfüllen!")
        return
    anrede = determine_anrede(ansprechpartner)
    betreff = f"{art} für ein Praktikum im Bereich {praktikum}"
    nachricht = result_text.get("1.0", "end-1c")
    now = datetime.now()

    try:
        c.execute('''
            INSERT INTO bewerbungen (art, name, praktikum, firma, telefon, anrede, ansprechpartner, betreff, nachricht, date)
            VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
        ''', (art, name, praktikum, firma, telefon, anrede, ansprechpartner, betreff, nachricht, now))
        conn.commit()
        messagebox.showinfo("Erfolg", "Bewerbung erfolgreich gespeichert!")
    except Exception as e:
        messagebox.showerror("Datenbankfehler", f"Fehler beim Speichern der Bewerbung:\n{e}")

# Funktion zur PDF-Erstellung
def speichere_als_pdf(text):
    pdf = FPDF()
    pdf.add_page()
    pdf.set_font("Arial", size=12)
    pdf.multi_cell(0, 10, text)
    dateiname = f"bewerbung_{datetime.now().strftime('%Y%m%d_%H%M%S')}.pdf"
    pdf.output(dateiname)
    messagebox.showinfo("Erfolg", f"PDF wurde gespeichert als {dateiname}!")

def oeffne_in_outlook():
    try:
        outlook = win32com.client.Dispatch("Outlook.Application")
        mail = outlook.CreateItem(0)
        mail.Subject = f"Betreff: {result_text.get('1.0', '1.60')}"
        mail.Body = result_text.get('1.61', 'end-1c')
        mail.Display()
    except Exception as e:
        messagebox.showerror("Fehler", f"Fehler beim Öffnen von Outlook: {e}")
        
def zeige_historie_fenster():
    # Lösche alle Widgets im Frame
    for widget in frame.winfo_children():
        widget.destroy()

    # Neues Frame für die Historie-Seite
    historie_frame = ctk.CTkFrame(frame)
    historie_frame.pack(fill="both", expand=True, padx=10, pady=10)

    # Label für die Historie
    ctk.CTkLabel(historie_frame, text="Bewerbungshistorie", font=("Helvetica", 18)).pack(pady=10)

    # Scrollbarer Bereich erstellen
    scrollable_frame = ctk.CTkFrame(historie_frame, fg_color="transparent")
    scrollable_frame.pack(fill="both", expand=True, padx=10, pady=10)

    # Canvas für den scrollbaren Bereich
    canvas = tk.Canvas(scrollable_frame, highlightthickness=0)
    canvas.pack(side="left", fill="both", expand=True)

    # Scrollbar erstellen
    scrollbar = ctk.CTkScrollbar(scrollable_frame, orientation="vertical", command=canvas.yview)
    scrollbar.pack(side="left", fill="y")

    # Inneres Frame für Buttons
    button_frame = ctk.CTkFrame(canvas, fg_color="transparent")
    canvas.create_window((0, 0), window=button_frame, anchor="nw")

    # Scrollregion aktualisieren, wenn das innere Frame wächst
    def update_scrollregion(event):
        canvas.configure(scrollregion=canvas.bbox("all"))

    button_frame.bind("<Configure>", update_scrollregion)
    canvas.configure(yscrollcommand=scrollbar.set)

    # Frame für die Buttons unterhalb des Textbereichs
    toolbar = ctk.CTkFrame(frame, fg_color="#e6f0fa")
    toolbar.pack(side="top", fill="x", padx=10, pady=10)

    # Button für Fett, Kursiv, Unterstrichen, Bewerbung, PDF mit gleicher Breite
    bold_button = ctk.CTkButton(toolbar_frame, text="Fett", command=lambda: toggle_bold(text_area), width=15)
    bold_button.pack(side="left", padx=5)


    italic_button = ctk.CTkButton(toolbar_frame, text="Kursiv", command=lambda: toggle_italic(text_area), width=15)
    italic_button.pack(side="left",fill="x", padx=5)


    underline_button = ctk.CTkButton(toolbar_frame, text="Unterstreichen", command=lambda: toggle_underline(text_area), width=15)
    underline_button.pack(side="left", padx=5)


    pdf_button = ctk.CTkButton(toolbar_frame, text="PDF", command=lambda: speichere_als_pdf(text_area.get("1.0", "end-1c")), width=15)
    pdf_button.pack(side="right", padx=5)


 # Bewerbung-Button im Historien-Frame (Start-Status: deaktiviert)
    global bewerbung_button
    bewerbung_button = ctk.CTkButton(toolbar_frame, text="Bewerbung", font=("Helvetica", 14), state="disabled", command=lambda: zeige_bewerbung_inhalt(frame))
    bewerbung_button.pack(side="right", padx=5)
    
    global Arbeitszeugnis_button
    Arbeitszeugnis_button = ctk.CTkButton(toolbar_frame, text="Arbeitszeugnis", font=("Helvetica", 14), command=lambda: upload_and_analyze(frame))
    Arbeitszeugnis_button.pack(side="bottom", padx=5)

# Rest des Codes für die Historie-Seite bleibt unverändert
    # Datenbankabfrage für Historie
    c.execute('SELECT id, firma, date FROM bewerbungen ORDER BY date DESC')
    bewerbungen = c.fetchall()

    # Buttons für die Historie-Einträge erstellen
    for b_id, firma, datum in bewerbungen:
        button = ctk.CTkButton(button_frame, text=f"{b_id}: {firma} - {datum}",
                               command=lambda id=b_id: lade_bewerbung(id))
        button.pack(fill="x", pady=2)

    # Detailanzeige bei Doppelklick
    def zeige_details(event):
        selected = listbox.curselection()
        if not selected:
            return
        index = selected[0]
        bewerbung_id = bewerbungen[index][0]  # ID des ausgewählten Eintrags

        # Detailabfrage
        c.execute('SELECT betreff, nachricht FROM bewerbungen WHERE id=?', (b_id,))
        result = c.fetchone()
        if result:
            betreff, nachricht = result
            messagebox.showinfo("Bewerbungsdetails", f"Betreff: {betreff}\n\n{nachricht}")


    global text_area
    text_area = tk.Text(historie_frame, height=10, wrap="word", font=("Helvetica", 12))
    text_area.pack(side="top", fill="both", expand=True, padx=10, pady=10)

    c.execute('SELECT id, firma, date FROM bewerbungen ORDER BY date DESC')
    bewerbungen = c.fetchall()

        # "Fett"-Button-Funktion
    def toggle_bold():
        try:
            selected_text = text_area.get(tk.SEL_FIRST, tk.SEL_LAST)
            if selected_text:
                text_area.delete(tk.SEL_FIRST, tk.SEL_LAST)
                text_area.insert(tk.INSERT, f"**{selected_text}**")
        except tk.TclError:
            messagebox.showwarning("Keine Auswahl", "Bitte markieren Sie Text, um ihn fett zu machen.")

    # "Kursiv"-Button-Funktion
    def toggle_italic():
        try:
            selected_text = text_area.get(tk.SEL_FIRST, tk.SEL_LAST)
            if selected_text:
                text_area.delete(tk.SEL_FIRST, tk.SEL_LAST)
                text_area.insert(tk.INSERT, f"*{selected_text}*")
        except tk.TclError:
            messagebox.showwarning("Keine Auswahl", "Bitte markieren Sie Text, um ihn kursiv zu machen.")

    # "Unterstreichen"-Button-Funktion
    def toggle_underline():
        try:
            selected_text = text_area.get(tk.SEL_FIRST, tk.SEL_LAST)
            if selected_text:
                text_area.delete(tk.SEL_FIRST, tk.SEL_LAST)
                text_area.insert(tk.INSERT, f"__{selected_text}__")
        except tk.TclError:
            messagebox.showwarning("Keine Auswahl", "Bitte markieren Sie Text, um ihn zu unterstreichen.")



    def zeige_bewerbung_inhalt(parent_frame):
    # Verwende vorhandenen Frame
        buttons_frame = ctk.CTkFrame(parent_frame)  # Nutzt den übergebenen Frame
        buttons_frame.pack(side="right", padx=10, pady=10, fill="y")

    # Buttons für die Historie-Einträge erstellen
    for b_id, firma, datum in bewerbungen:
        button = ctk.CTkButton(button_frame, text=f"{b_id}: {firma} - {datum}",
                              command=lambda id=b_id: lade_bewerbung(id))
        button.pack(fill="x", pady=2)

def zeige_deckblatt(bewerbung_id):
    # Datenbankabfrage für den ausgewählten Historie-Eintrag
    c.execute('SELECT name, firma, betreff, date FROM bewerbungen WHERE id=?', (bewerbung_id,))
    result = c.fetchone()

    if not result:
        messagebox.showerror("Fehler", "Daten für das Deckblatt konnten nicht geladen werden.")
        return

    name, firma, betreff, datum = result

    # Erstelle das Deckblatt
    deckblatt_content = f"""
    {name}

    {datum.strftime('%d.%m.%Y')}

    {firma}
    ----------------------------------------
    {betreff.upper()}
    ----------------------------------------

    Vielen Dank für die Möglichkeit, mich bei Ihnen vorzustellen. 
    Ich freue mich, Ihnen meine Erfahrungen und Kompetenzen darlegen zu dürfen.
    """
    
    # Zeige das Deckblatt im Textbereich an
    text_area.delete("1.0", "end")
    text_area.insert("1.0", deckblatt_content)

def zeige_motivationsschreiben(bewerbung_id):
    # Datenbankabfrage für den ausgewählten Historie-Eintrag
    c.execute('SELECT name, firma, betreff, nachricht, ansprechpartner FROM bewerbungen WHERE id=?', (bewerbung_id,))
    result = c.fetchone()

    if not result:
        messagebox.showerror("Fehler", "Daten für das Motivationsschreiben konnten nicht geladen werden.")
        return

    name, firma, betreff, nachricht, ansprechpartner = result

    # Erstelle ein modernes Motivationsschreiben
    motivationsschreiben_content = f"""
    {name}
    ----------------------------------------

    {firma}
    {ansprechpartner if ansprechpartner else "Personalabteilung"}

    Betreff: {betreff}

    Sehr geehrte Damen und Herren,

    ich freue mich, die Gelegenheit zu nutzen, mich für die Position bei Ihrer geschätzten Firma {firma} zu bewerben. 
    Mit meiner Erfahrung und meinem Engagement für Exzellenz bin ich überzeugt, einen wertvollen Beitrag zu Ihrem Unternehmen leisten zu können.

    {nachricht}

    Ich würde mich freuen, Ihnen in einem persönlichen Gespräch mehr über mich und meine Motivation zu erzählen.
    Vielen Dank für Ihre Zeit und die Prüfung meiner Bewerbung.

    Mit freundlichen Grüßen,

    {name}
    ----------------------------------------
    """
    
    # Zeige das Motivationsschreiben im Textbereich an
    text_area.delete("1.0", "end")
    text_area.insert("1.0", motivationsschreiben_content)

# Variable, um den zuletzt bearbeiteten Lebenslauf zu speichern
lebenslauf_inhalt = None

def zeige_lebenslauf():
    global lebenslauf_inhalt

    if lebenslauf_inhalt is None:
        # Erstellt eine neue Lebenslauf-Vorlage
        lebenslauf_inhalt = """
        Lebenslauf

        Persönliche Daten:
        ------------------
        Name: [Ihr Name]
        Adresse: [Ihre Adresse]
        Telefon: [Ihre Telefonnummer]
        E-Mail: [Ihre E-Mail-Adresse]

        Berufserfahrung:
        ----------------
        1. [Ihr letzter Job]
           Firma: [Name der Firma]
           Zeitraum: [Von - Bis]
           Aufgaben: [Beschreibung Ihrer Aufgaben]

        2. [Ein weiterer Job]
           Firma: [Name der Firma]
           Zeitraum: [Von - Bis]
           Aufgaben: [Beschreibung Ihrer Aufgaben]

        Ausbildung:
        -----------
        [Details Ihrer Ausbildung]

        Fähigkeiten:
        ------------
        - [Fähigkeit 1]
        - [Fähigkeit 2]
        - [Fähigkeit 3]

        Sprachen:
        ---------
        - [Sprache 1] (Niveau: [z.B. Muttersprachlich, Fließend])
        - [Sprache 2] (Niveau: [z.B. Grundkenntnisse])

        Interessen:
        -----------
        - [Interesse 1]
        - [Interesse 2]
        """

    # Zeige den Lebenslauf im Textbereich an
    text_area.delete("1.0", "end")
    text_area.insert("1.0", lebenslauf_inhalt)

def speichere_lebenslauf():
    global lebenslauf_inhalt
    # Speichert den bearbeiteten Lebenslauf
    lebenslauf_inhalt = text_area.get("1.0", "end-1c")
    messagebox.showinfo("Erfolg", "Lebenslauf wurde gespeichert!")

def zeige_bewerbung_buttons():
    for widget in bewerbung_frame.winfo_children():
        widget.destroy()
    deckblatt_button = ctk.CTkButton(bewerbung_frame, text="Deckblatt", font=("Helvetica", 14),
                                     command=lambda: zeige_deckblatt(aktuelle_bewerbung_id))
    deckblatt_button.pack(fill="x", pady=5)
    motivation_button = ctk.CTkButton(bewerbung_frame, text="Motivationsschreiben", font=("Helvetica", 14),
                                      command=lambda: zeige_motivationsschreiben(aktuelle_bewerbung_id))
    motivation_button.pack(fill="x", pady=5)
    lebenslauf_button = ctk.CTkButton(bewerbung_frame, text="Lebenslauf", font=("Helvetica", 14),
                                      command=zeige_lebenslauf)
    lebenslauf_button.pack(fill="x", pady=5)
    speichern_button = ctk.CTkButton(bewerbung_frame, text="Speichern", font=("Helvetica", 14),
                                     command=speichere_lebenslauf)
    speichern_button.pack(fill="x", pady=5)
# Bewerbung-Button im Historien-Frame (Start-Status: deaktiviert)
    global bewerbung_button
    # Bewerbung-Button (kann initial deaktiviert sein)
    bewerbung_button = ctk.CTkButton(toolbar_frame, text="Bewerbung", state="disabled", command=zeige_bewerbung_buttons)
    bewerbung_button.pack(side="left", padx=5)
    # Speichern-Button für Lebenslauf hinzufügen
    speichern_button = ctk.CTkButton(
        bewerbung_frame, text="Speichern", font=("Helvetica", 14),
        command=speichere_lebenslauf
    )
    speichern_button.pack(fill="x", pady=5)
def zeige_historie_fenster():
    for widget in frame.winfo_children():
        widget.destroy()
    historie_frame = ctk.CTkFrame(frame)
    historie_frame.pack(fill="both", expand=True, padx=10, pady=10)
    scrollable_frame = ctk.CTkFrame(historie_frame, fg_color="transparent")
    scrollable_frame.pack(fill="both", expand=True, padx=10, pady=10)
    canvas = tk.Canvas(scrollable_frame, highlightthickness=0)
    canvas.pack(side="left", fill="both", expand=True)
    scrollbar = ctk.CTkScrollbar(scrollable_frame, orientation="vertical", command=canvas.yview)
    scrollbar.pack(side="right", fill="y")
    button_frame = ctk.CTkFrame(canvas, fg_color="transparent")
    canvas.create_window((0, 0), window=button_frame, anchor="nw")
    canvas.configure(yscrollcommand=scrollbar.set)
    c.execute('SELECT id, firma, date FROM bewerbungen ORDER BY date DESC')
    bewerbungen = c.fetchall()
    for b_id, firma, datum in bewerbungen:
        button = ctk.CTkButton(button_frame, text=f"{b_id}: {firma} - {datum}",
                               command=lambda id=b_id: lade_bewerbung(id))
        button.pack(fill="x", pady=2)
    global text_area
    text_area = tk.Text(historie_frame, height=10, wrap="word", font=("Helvetica", 12))
    text_area.pack(fill="both", expand=True, padx=10, pady=10)
    global bewerbung_frame
    bewerbung_frame = ctk.CTkFrame(historie_frame, fg_color="transparent")
    bewerbung_frame.pack(fill="x", padx=10, pady=10)

   

 
    # Frame für Bewerbung-Buttons
    bewerbung_frame = ctk.CTkFrame(historie_frame, fg_color="transparent")
    bewerbung_frame.pack(fill="x", padx=10, pady=10)
    # Funktion für die Anzeige der verschiedenen Dokumente
    def show_content(option):
        if option == "Deckblatt":
            content = f"Deckblatt für {name_entry.get()} - {firma_entry.get()}"
        elif option == "Motivationsschreiben":
            content = f"Motivationsschreiben von {name_entry.get()} - {firma_entry.get()}"
        else:
            content = f"Lebenslauf von {name_entry.get()} - {firma_entry.get()}"
        text_area_left.delete("1.0", "end")
        text_area_left.insert("1.0", content)

def lade_bewerbung(bewerbung_id):
    global aktuelle_bewerbung_id
    aktuelle_bewerbung_id = bewerbung_id  # Speichere die ID der aktuellen Bewerbung

    # Lade die Details der Bewerbung
    c.execute('SELECT betreff, nachricht FROM bewerbungen WHERE id=?', (bewerbung_id,))
    result = c.fetchone()

    if result:
        betreff, nachricht = result
        text_area.configure(state="normal")
        text_area.delete("1.0", "end")
        text_area.insert("1.0", f"Betreff: {betreff}\n\n{nachricht}")


from tkinter import filedialog, messagebox, Toplevel, Text
from PyPDF2 import PdfReader

def upload_and_analyze(parent=None):
    """
    Öffnet einen Dialog zum Hochladen einer PDF-Datei,
    analysiert die Datei und zeigt die Ergebnisse an.
    """
    # Dialog zum Hochladen einer PDF-Datei
    file_path = filedialog.askopenfilename(
        title="PDF auswählen",
        filetypes=[("PDF Dateien", "*.pdf")]
    )
    
    if file_path:
        # PDF analysieren und den Text extrahieren
        pdf_text = extract_text_from_pdf(file_path)
        clean_text = clean_pdf_text(pdf_text)  # Text aufräumen
        
        # Analyse des Arbeitszeugnisses
        sentiment, analysis_details = analyze_pdf_text(clean_text)
        
        # Ergebnis anzeigen
        display_analysis(parent, sentiment, analysis_details, clean_text)
    else:
        messagebox.showwarning("Keine Datei ausgewählt", "Bitte wählen Sie eine PDF-Datei aus!")

def extract_text_from_pdf(file_path):
    """Extrahiert den Text aus einer PDF-Datei."""
    reader = PdfReader(file_path)
    text = ""
    for page in reader.pages:
        text += page.extract_text()
    return text

def clean_pdf_text(text):
    """Bereinigt den Text, entfernt überflüssige Leerzeichen und strukturiert ihn in Absätze."""
    lines = text.splitlines()  # Text in Zeilen zerlegen
    cleaned_lines = [line.strip() for line in lines if line.strip()]  # Leerzeilen entfernen
    return "\n\n".join(cleaned_lines)  # Absätze durch Leerzeilen trennen

def analyze_pdf_text(text):
    """Analysiert den Text und bewertet das Arbeitszeugnis."""
    positive_keywords = ["zuverlässig", "engagiert", "fachkenntnisse", "dank", "hervorragend", "vorbildlich", "zufriedenheit"]
    negative_keywords = ["bemühte", "im Rahmen seiner Möglichkeiten", "allgemeinen Unternehmensrichtlinien", "höflich und korrekt", "freundliche Art", "zu unserer Zufriedenheit"]

    positive_score = sum(word in text.lower() for word in positive_keywords)
    negative_score = sum(word in text.lower() for word in negative_keywords)
    
    if positive_score > negative_score:
        sentiment = "Positiv"
        details = f"Das Zeugnis enthält überwiegend positive Formulierungen. Positive Punkte: {positive_score}, Negative Punkte: {negative_score}."
    elif negative_score > positive_score:
        sentiment = "Negativ"
        details = f"Das Zeugnis enthält mehrere negative Formulierungen. Positive Punkte: {positive_score}, Negative Punkte: {negative_score}."
    else:
        sentiment = "Neutral"
        details = f"Das Zeugnis ist insgesamt neutral. Positive Punkte: {positive_score}, Negative Punkte: {negative_score}."
    
    return sentiment, details

def display_analysis(parent, sentiment, analysis_details, text):
    """Zeigt die Analyse-Ergebnisse in einem separaten Fenster an."""
    if parent is None:
        raise ValueError("Ein Eltern-Widget muss übergeben werden.")
    
    output_window = Toplevel(parent)
    output_window.title("Analyse des Arbeitszeugnisses")
    output_window.geometry()
    
    # Textfeld für die Ausgabe
    output_text = Text(output_window, wrap="word", font=("Arial", 12))
    output_text.insert("1.0", f"Einschätzung: {sentiment}\n")
    output_text.insert("2.0", f"Details: {analysis_details}\n\n")
    output_text.insert("3.0", "Analyzierter Text aus der PDF-Datei:\n\n")
    output_text.insert("4.0", text)
    output_text.config(state="disabled")  # Nur Lesezugriff
    output_text.pack(expand=True, fill="both", padx=10, pady=10)

app = ctk.CTk()
app.title("Bewerbungsassistent")
app.geometry()
app.configure(fg_color="#e6f0fa")

frame = ctk.CTkFrame(app, corner_radius=10)
frame.grid(row=0, column=0, sticky="nsew", padx=25, pady=25)

art_var = ctk.StringVar(value="Bewerbung")
ctk.CTkLabel(frame, text="Art der E-Mail:", font=("Helvetica", 16)).grid(row=0, column=0, sticky="w")
ctk.CTkRadioButton(frame, text="Bewerbung", variable=art_var, value="Bewerbung", font=("Helvetica", 14)).grid(row=0, column=1, sticky="w")
ctk.CTkRadioButton(frame, text="Anfrage", variable=art_var, value="Anfrage", font=("Helvetica", 14)).grid(row=0, column=2, sticky="w")

ctk.CTkLabel(frame, text="Dein Name:", font=("Helvetica", 16)).grid(row=1, column=0, sticky="w")
name_entry = ctk.CTkEntry(frame, width=450, font=("Helvetica", 14))
name_entry.grid(row=1, column=1, columnspan=2)

ctk.CTkLabel(frame, text="Tel.:", font=("Helvetica", 16)).grid(row=2, column=0, sticky="w")
telefon_entry = ctk.CTkEntry(frame, width=450, font=("Helvetica", 14))
telefon_entry.grid(row=2, column=1, columnspan=2)

ctk.CTkLabel(frame, text="Beruf auswählen:", font=("Helvetica", 16)).grid(row=3, column=0, sticky="w", pady=(10, 0))
beruf_var = ctk.StringVar(value="Bitte Beruf wählen")
beruf_dropdown = ctk.CTkOptionMenu(frame, variable=beruf_var, values=berufe, width=450)
beruf_dropdown.grid(row=3, column=1, columnspan=2)

# Funktion zum Öffnen eines Scroll-Menüs mit Suchfunktion
def open_scrollable_dropdown():
    # Dropdown-Menü erstellen
    dropdown_menu = ctk.CTkFrame(frame, width=450, height=300, fg_color="gray")
    
    # Position relativ zum Button ändern
    dropdown_x = beruf_dropdown.winfo_x() -45 # X-Position des Dropdown-Buttons
    dropdown_y = beruf_dropdown.winfo_y() -38 + beruf_dropdown.winfo_height() + 10  # Y-Position direkt unterhalb + Offset

    # Menü an der gewünschten Position platzieren
    dropdown_menu.place(x=dropdown_x, y=dropdown_y)

    # Canvas erstellen (für die Scrollbarkeit)
    canvas = tk.Canvas(dropdown_menu, width=350, height=230, highlightthickness=0)
    canvas.pack(side="left", fill="both", expand=True, pady=(2, 0))

    # Scrollbar hinzufügen
    scrollbar = ctk.CTkScrollbar(dropdown_menu, orientation="vertical", command=canvas.yview)
    scrollbar.pack(side="left", fill="y")

    # Inneres Frame für die Berufe
    list_frame = ctk.CTkFrame(canvas)
    canvas.create_window((0, 0), window=list_frame, anchor="w")

    # Scrollregion aktualisieren, wenn der Inhalt wächst
    def update_scrollregion(event):
        canvas.configure(scrollregion=canvas.bbox("all"))

    list_frame.bind("<Configure>", update_scrollregion)
    canvas.configure(yscrollcommand=scrollbar.set)

    # Einträge in das Frame einfügen
    def populate_list(filtered_list):
        for widget in list_frame.winfo_children():
            widget.destroy()  # Lösche alte Einträge
        for beruf in filtered_list:
            button = ctk.CTkButton(list_frame, text=beruf, anchor="w", command=lambda b=beruf: select_beruf(b))
            button.pack(fill="x", pady=2)

    # Auswahl setzen und Dropdown schließen
    def select_beruf(selected_beruf):
        beruf_var.set(selected_beruf)
        dropdown_menu.place_forget()  # Menü schließen

    # Initial die gesamte Berufsliste anzeigen
    populate_list(berufe)

    # Suchfunktion
    def search_berufe(event):
        search_term = search_entry.get().lower()
        filtered_list = [beruf for beruf in berufe if search_term in beruf.lower()]
        populate_list(filtered_list)

    # Suchfeld erstellen
    search_entry = ctk.CTkEntry(dropdown_menu, placeholder_text="Suche Berufe...")
    search_entry.pack(side="left", fill="x", pady=(5, 0), padx=10)
    search_entry.bind("<KeyRelease>", search_berufe)

# Ersetze das `CTkOptionMenu` durch einen Button, der das Scroll-Menü öffnet
beruf_dropdown = ctk.CTkButton(
    frame, textvariable=beruf_var, command=open_scrollable_dropdown, width=450
)
beruf_dropdown.grid(row=3, column=1, columnspan=2)

# Optional: Label für das Suchfeld anzeigen
search_label = ctk.CTkLabel(frame, text="Suche nach einem Beruf:", font=("Helvetica", 12))
search_label.grid(row=4, column=0, columnspan=3, pady=(10, 0))


ctk.CTkLabel(frame, text="Firma:", font=("Helvetica", 16)).grid(row=4, column=0, sticky="w", pady=(10, 0))
firma_entry = ctk.CTkEntry(frame, width=450, font=("Helvetica", 14))
firma_entry.grid(row=4, column=1, columnspan=2)

ctk.CTkLabel(frame, text="Ansprechpartner:", font=("Helvetica", 16)).grid(row=5, column=0, sticky="w", pady=(10, 0))
ansprechpartner_entry = ctk.CTkEntry(frame, width=450, font=("Helvetica", 14))
ansprechpartner_entry.grid(row=5, column=1, columnspan=2)

result_text = Text(frame, height=20, width=60, wrap="word", font=("Helvetica", 12), padx=10, pady=10)
result_text.grid(row=6, column=0, columnspan=3, padx=20, pady=20)

speichern_button = ctk.CTkButton(frame, text="Bewerbung generieren und speichern", font=("Helvetica", 14), command=zeige_bewerbung)
speichern_button.grid(row=7, column=0, columnspan=3, pady=10)

historie_button = ctk.CTkButton(frame, text="Bewerbungshistorie", font=("Helvetica", 14), command=zeige_historie_fenster)
historie_button.grid(row=8, column=0, columnspan=3, pady=10)

outlook_button = ctk.CTkButton(frame, text="In Outlook öffnen", font=("Helvetica", 14), command=oeffne_in_outlook)
outlook_button.grid(row=9, column=0, columnspan=4, pady=15)



app.mainloop()
