import customtkinter as ctk
from tkinter import messagebox
import sqlite3
from datetime import datetime
from fpdf import FPDF
from PIL import Image, ImageTk  # Für das PDF-Symbol

# Datenbank-Verbindung
conn = sqlite3.connect('bewerbungen.db')
c = conn.cursor()

# Erstelle Tabelle, falls sie nicht vorhanden ist
c.execute('''
    CREATE TABLE IF NOT EXISTS bewerbungen (
        id INTEGER PRIMARY KEY,
        art TEXT,
        name TEXT,
        praktikum TEXT,
        firma TEXT,
        telefon TEXT,
        anrede TEXT,
        ansprechpartner TEXT,
        betreff TEXT,
        nachricht TEXT,
        date TEXT
    )
''')
conn.commit()

# Funktion zur Bestimmung der Anrede (Dummy-Funktion, falls erforderlich)
def determine_anrede(ansprechpartner):
    return 'Sehr geehrte/r'

# Funktion zum Speichern der Bewerbung in der Datenbank
def speichere_bewerbung(art, name, praktikum, firma, telefon, anrede, ansprechpartner, betreff, nachricht):
    datum = datetime.now().strftime("%Y-%m-%d %H:%M:%S")
    c.execute('''
        INSERT INTO bewerbungen (art, name, praktikum, firma, telefon, anrede, ansprechpartner, betreff, nachricht, date)
        VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
    ''', (art, name, praktikum, firma, telefon, anrede, ansprechpartner, betreff, nachricht, datum))
    conn.commit()

# Funktion zur Generierung der Bewerbung
def generiere_bewerbung(art, name, praktikum, firma, telefon, anrede, ansprechpartner):
    anrede = determine_anrede(ansprechpartner)
    betreff = f"{art} für ein Praktikum"
    nachricht = (
        f"{anrede} {ansprechpartner},\n\n"
        f"ich bin {name} und mache eine Umschulung im Bereich {praktikum}. "
        f"Mit großem Interesse habe ich von Ihrem Unternehmen {firma} gehört.\n\n"
        f"Mit freundlichen Grüßen,\n{name}\nTel.: {telefon}"
    )
    return betreff, nachricht

# Funktion zur Anzeige und Speicherung der Bewerbung
def zeige_bewerbung():
    art = art_var.get()
    name = name_entry.get()
    praktikum = beruf_var.get()
    firma = firma_entry.get()
    telefon = telefon_entry.get()
    ansprechpartner = ansprechpartner_entry.get()
    anrede = determine_anrede(ansprechpartner)
    
    betreff, nachricht = generiere_bewerbung(art, name, praktikum, firma, telefon, anrede, ansprechpartner)

    if betreff and nachricht:
        result_text.delete("1.0", "end")
        result_text.insert("end", f"Betreff: {betreff}\n\n{nachricht}")
        speichere_bewerbung(art, name, praktikum, firma, telefon, anrede, ansprechpartner, betreff, nachricht)

# Funktion zur PDF-Erstellung
def speichere_als_pdf(text):
    pdf = FPDF()
    pdf.add_page()
    pdf.set_font("Arial", size=12)
    pdf.multi_cell(0, 10, text)
    pdf.output("bewerbung.pdf")
    messagebox.showinfo("Erfolg", "PDF wurde gespeichert!")

# Funktion zur Anwendung von Textformatierungen
def toggle_bold(text_widget):
    current_tags = text_widget.tag_names("sel.first")
    if "bold" in current_tags:
        text_widget.tag_remove("bold", "sel.first", "sel.last")
    else:
        text_widget.tag_add("bold", "sel.first", "sel.last")
        text_widget.tag_configure("bold", font=("Helvetica", 12, "bold"))

def toggle_italic(text_widget):
    current_tags = text_widget.tag_names("sel.first")
    if "italic" in current_tags:
        text_widget.tag_remove("italic", "sel.first", "sel.last")
    else:
        text_widget.tag_add("italic", "sel.first", "sel.last")
        text_widget.tag_configure("italic", font=("Helvetica", 12, "italic"))

def toggle_underline(text_widget):
    current_tags = text_widget.tag_names("sel.first")
    if "underline" in current_tags:
        text_widget.tag_remove("underline", "sel.first", "sel.last")
    else:
        text_widget.tag_add("underline", "sel.first", "sel.last")
        text_widget.tag_configure("underline", font=("Helvetica", 12, "underline"))

# Historienfenster anzeigen
def zeige_historie_fenster():
    historie_window = ctk.CTkToplevel(app)
    historie_window.title("Bewerbungshistorie")
    historie_window.geometry("700x500")
    historie_window.configure(fg_color="#e6f0fa")

    # Setze das Historienfenster immer in den Vordergrund
    historie_window.transient(app)
    historie_window.grab_set()
    historie_window.attributes("-topmost", True)

    # Haupt-Frame für die Firmenliste und den Textbereich
    frame = ctk.CTkFrame(historie_window, fg_color="#e6f0fa")
    frame.pack(fill="both", expand=True, padx=10, pady=10)

    # Firmenliste mit Datum und Uhrzeit (nur lesbar)
    listbox_frame = ctk.CTkFrame(frame)
    listbox_frame.pack(side="left", fill="y", padx=10, pady=10)

    listbox = ctk.CTkTextbox(listbox_frame, wrap="none", state="disabled")  # Setze auf 'disabled' für Nur-Lesen
    listbox.pack(fill="both", expand=True)

    # Textbereich zur Anzeige und Bearbeitung der Bewerbung
    text_area = ctk.CTkTextbox(frame, height=20, width=60, wrap="word", padx=10, pady=10)
    text_area.pack(side="right", fill="both", expand=True)
    
    # Toolbar für Textformatierungen
    toolbar = ctk.CTkFrame(historie_window, fg_color="#e6f0fa")
    toolbar.pack(fill="x", padx=10)

    bold_button = ctk.CTkButton(toolbar, text="Fett", command=lambda: toggle_bold(text_area))
    bold_button.pack(side="left", padx=5)

    italic_button = ctk.CTkButton(toolbar, text="Kursiv", command=lambda: toggle_italic(text_area))
    italic_button.pack(side="left", padx=5)

    underline_button = ctk.CTkButton(toolbar, text="Unterstrichen", command=lambda: toggle_underline(text_area))
    underline_button.pack(side="left", padx=5)

    pdf_button = ctk.CTkButton(toolbar, text="PDF", command=lambda: speichere_als_pdf(text_area.get("1.0", "end-1c")))
    pdf_button.pack(side="right", padx=5)

    # Firmen und Daten aus der Datenbank abrufen
    c.execute('SELECT firma, date, id FROM bewerbungen')
    bewerbungen = c.fetchall()
    listbox.configure(state="normal")  # Ermögliche temporär das Schreiben
    for firma, datum, bewerbung_id in bewerbungen:
        button = ctk.CTkButton(listbox_frame, text=f"{firma} - {datum}", command=lambda f=firma: zeige_bewerbung(f))
        button.pack(fill="x", pady=2)

    listbox.configure(state="disabled")  # Setze wieder auf Nur-Lesen

def zeige_bewerbung(firma):
    c.execute('SELECT betreff, nachricht FROM bewerbungen WHERE firma=?', (firma,))
    result = c.fetchone()
    if result:
        betreff, nachricht = result
        text_area.configure(state="normal")
        text_area.delete("1.0", "end")
        text_area.insert("1.0", f"Betreff: {betreff}\n\n{nachricht}")
        text_area.configure(state="normal")  # Bearbeitbar machen

# Hauptfenster erstellen
app = ctk.CTk()
app.title("E-Mail Bewerbungsassistent")
app.geometry("690x730")
app.configure(fg_color="#e6f0fa")

window_width = 690
window_height = 780
screen_width = app.winfo_screenwidth()
screen_height = app.winfo_screenheight()
position_top = int(screen_height / 2 - window_height / 2)
position_right = int(screen_width / 2 - window_width / 2)
app.geometry(f'{window_width}x{window_height}+{position_right}+{position_top}')


frame = ctk.CTkFrame(app, corner_radius=10)
frame.grid(row=0, column=0, sticky="nsew", padx=25, pady=25)

art_var = ctk.StringVar(value="Bewerbung")
ctk.CTkLabel(frame, text="Art der E-Mail:", font=("Helvetica", 16)).grid(row=0, column=0, sticky="w")
ctk.CTkRadioButton(frame, text="Bewerbung", variable=art_var, value="Bewerbung", font=("Helvetica", 14)).grid(row=0, column=1, sticky="w")
ctk.CTkRadioButton(frame, text="Anfrage", variable=art_var, value="Anfrage", font=("Helvetica", 14)).grid(row=0, column=2, sticky="w")

ctk.CTkLabel(frame, text="Dein Name:", font=("Helvetica", 16)).grid(row=1, column=0, sticky="w")
name_entry = ctk.CTkEntry(frame, width=450, font=("Helvetica", 14))
name_entry.grid(row=1, column=1, columnspan=2)

ctk.CTkLabel(frame, text="Tel.:", font=("Helvetica", 16)).grid(row=2, column=0, sticky="w")
telefon_entry = ctk.CTkEntry(frame, width=450, font=("Helvetica", 14))
telefon_entry.grid(row=2, column=1, columnspan=2)

ctk.CTkLabel(frame, text="Praktikum im Bereich:", font=("Helvetica", 16)).grid(row=3, column=0, sticky="w", pady=(20, 0))
beruf_var = ctk.StringVar(value="Fachinformatiker für Anwendungsentwicklung")
ctk.CTkOptionMenu(frame, variable=beruf_var, values=["Fachinformatiker für Anwendungsentwicklung", "Fachinformatiker für Systemintegration"], font=("Helvetica", 14)).grid(row=3, column=1, columnspan=2)

ctk.CTkLabel(frame, text="Firma:", font=("Helvetica", 16)).grid(row=4, column=0, sticky="w", pady=(10, 0))
firma_entry = ctk.CTkEntry(frame, width=450, font=("Helvetica", 14))
firma_entry.grid(row=4, column=1, columnspan=2)

ctk.CTkLabel(frame, text="Ansprechpartner:", font=("Helvetica", 16)).grid(row=5, column=0, sticky="w", pady=(10, 0))
ansprechpartner_entry = ctk.CTkEntry(frame, width=450, font=("Helvetica", 14))
ansprechpartner_entry.grid(row=5, column=1, columnspan=2)

result_text = ctk.CTkTextbox(frame, height=300, width=600, wrap="word", font=("Helvetica", 12), padx=10, pady=10)
result_text.grid(row=6, column=0, columnspan=3, padx=20, pady=20)

speichern_button = ctk.CTkButton(frame, text="Bewerbung generieren und speichern", font=("Helvetica", 14), command=zeige_bewerbung)
speichern_button.grid(row=7, column=0, columnspan=3, pady=10)

historie_button = ctk.CTkButton(frame, text="Bewerbungshistorie", font=("Helvetica", 14), command=zeige_historie_fenster)
historie_button.grid(row=8, column=0, columnspan=3, pady=10)

app.mainloop()
