import customtkinter as ctk
from tkinter import messagebox, Text, NORMAL
import sqlite3
from datetime import datetime
from fpdf import FPDF
import os

# Datenbank-Verbindung
conn = sqlite3.connect('bewerbungen.db')
conn.text_factory = str  # Sicherstellung von UTF-8 Unterstützung
c = conn.cursor()

# Tabelle erstellen, falls nicht vorhanden
c.execute('''CREATE TABLE IF NOT EXISTS bewerbungen (
    id INTEGER PRIMARY KEY,
    art TEXT,
    name TEXT,
    praktikum TEXT,
    firma TEXT,
    telefon TEXT,
    anrede TEXT,
    ansprechpartner TEXT,
    betreff TEXT,
    nachricht TEXT,
    date TEXT
)''')
conn.commit()

# Funktion zur Bestimmung der Anrede
def determine_anrede(ansprechpartner):
    return "Sehr geehrte/r"

# Funktion zum Speichern der Bewerbung in der Datenbank
def speichere_bewerbung(art, name, praktikum, firma, telefon, anrede, ansprechpartner, betreff, nachricht):
    datum = datetime.now().strftime("%Y-%m-%d %H:%M:%S")
    c.execute('''INSERT INTO bewerbungen (art, name, praktikum, firma, telefon, anrede, ansprechpartner, betreff, nachricht, date)
                 VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)''', 
              (art, name, praktikum, firma, telefon, anrede, ansprechpartner, betreff, nachricht, datum))
    conn.commit()

# Funktion zur Generierung der Bewerbung
def generiere_bewerbung(art, name, praktikum, firma, telefon, anrede, ansprechpartner):
    anrede = determine_anrede(ansprechpartner)
    betreff = f"{art} für ein Praktikum"
    nachricht = (f"{anrede} {ansprechpartner},\n\n"
                 f"Ich bin {name} und mache eine Umschulung im Bereich {praktikum}. "
                 f"Mit großem Interesse habe ich von Ihrem Unternehmen {firma} gehört.\n\n"
                 f"Mit freundlichen Grüßen,\n{name}\nTel.: {telefon}")
    return betreff, nachricht

# Funktion zur Anzeige und Speicherung der Bewerbung
def zeige_bewerbung():
    art = art_var.get()
    name = name_entry.get()
    praktikum = beruf_var.get()
    firma = firma_entry.get()
    telefon = telefon_entry.get()
    ansprechpartner = ansprechpartner_entry.get()
    anrede = determine_anrede(ansprechpartner)
    
    betreff, nachricht = generiere_bewerbung(art, name, praktikum, firma, telefon, anrede, ansprechpartner)

    if betreff and nachricht:
        result_text.delete("1.0", "end")
        result_text.insert("end", f"Betreff: {betreff}\n\n{nachricht}")
        speichere_bewerbung(art, name, praktikum, firma, telefon, anrede, ansprechpartner, betreff, nachricht)

# Funktion zur PDF-Erstellung
def speichere_als_pdf(text):
    pdf = FPDF()
    pdf.add_page()
    pdf.set_font("Arial", size=12)
    pdf.multi_cell(0, 10, text)
    dateiname = f"bewerbung_{datetime.now().strftime('%Y%m%d_%H%M%S')}.pdf"
    pdf.output(dateiname)
    messagebox.showinfo("Erfolg", f"PDF wurde gespeichert als {dateiname}!")

# Funktion zur Anzeige der Bewerbungshistorie
def zeige_historie_fenster():
    for widget in frame.winfo_children():
        widget.destroy()

    listbox_frame = ctk.CTkFrame(frame)
    listbox_frame.pack(side="left", fill="y", padx=10, pady=10)

    global text_area
    text_area = Text(frame, height=20, width=60, wrap="word", padx=10, pady=10, font=("Helvetica", 12))
    text_area.pack(side="top", fill="both", expand=True)

    c.execute('SELECT id, firma, date FROM bewerbungen')
    bewerbungen = c.fetchall()

    for bewerbung_id, firma, datum in bewerbungen:
        button = ctk.CTkButton(listbox_frame, text=f"{firma} - {datum}",
                               command=lambda id=bewerbung_id: lade_bewerbung(id))
        button.pack(fill="x", pady=2)

    toolbar = ctk.CTkFrame(frame, fg_color="#e6f0fa")
    toolbar.pack(side="bottom", fill="x", padx=10, pady=10)

    pdf_button = ctk.CTkButton(toolbar, text="PDF", command=lambda: speichere_als_pdf(text_area.get("1.0", "end-1c")))
    pdf_button.pack(side="right", padx=5)

    # Button zur Erstellung einer neuen Bewerbung
    inhalt_button = ctk.CTkButton(toolbar, text="Neue Bewerbung",
                                  command=zeige_bewerbungsinhalt)
    inhalt_button.pack(side="right", padx=10)

# Funktion zur Anzeige eines Bewerbungseintrags
def lade_bewerbung(bewerbung_id):
    c.execute('SELECT betreff, nachricht FROM bewerbungen WHERE id=?', (bewerbung_id,))
    result = c.fetchone()
    if result:
        betreff, nachricht = result
        text_area.configure(state="normal")
        text_area.delete("1.0", "end")
        text_area.insert("1.0", f"Betreff: {betreff}\n\n{nachricht}")
        text_area.configure(state="normal")

# Funktion zur Darstellung der Bewerbungsinhalte im selben Fenster
def zeige_bewerbungsinhalt():
    for widget in frame.winfo_children():
        widget.destroy()
    
    # Linksseitige Auswahlbuttons
    left_frame = ctk.CTkFrame(bewerbung_window, width=150)
    left_frame.pack(side="left", fill="y", padx=10, pady=10)

    # Rechter Frame zur Anzeige der Inhalte
    right_frame = ctk.CTkFrame(bewerbung_window)
    right_frame.pack(side="right", expand=True, fill="both", padx=10, pady=10)

    # Optionen zur Auswahl
    options = ["Deckblatt Oberfläche", "Motivationsschreiben", "Lebenslauf Schreiben"]
    for option in options:
        button = ctk.CTkButton(left_frame, text=option, font=("Arial", 12), command=lambda opt=option: display_content(opt, right_frame))
        button.pack(pady=10, fill="x")

# Anzeige von dynamischem Inhalt im rechten Frame
def display_content(option, frame):
    for widget in frame.winfo_children():
        widget.destroy()
    
    if option == "Deckblatt Oberfläche":
        # Generiere ein vollständiges Deckblatt mit den Eingabedaten
        deckblatt_text = (
            f"{name_entry.get()}\n"  # Name des Bewerbers
            f"{firma_entry.get()}\n\n"  # Firmenname
            f"Anschrift: [Adresse einfügen]\n"  # Adresse des Bewerbers
            f"Telefonnummer: {telefon_entry.get()}\n"
            f"Datum: {datetime.now().strftime('%d.%m.%Y')}\n\n"
            f"Bewerbung um ein Praktikum als {beruf_var.get()}\n\n"
            "Sehr geehrte Damen und Herren,\n\n"
            f"Hiermit bewerbe ich mich auf das ausgeschriebene Praktikum bei {firma_entry.get()}. "
            "Ich habe großes Interesse daran, mein Wissen im Bereich der Anwendungsentwicklung zu erweitern und praktische "
            "Erfahrungen zu sammeln.\n\n"
            "Mit freundlichen Grüßen,\n\n"
            f"{name_entry.get()}"
        )
        
        # Zeige das generierte Deckblatt in einem bearbeitbaren Textfeld
        content = Text(frame, wrap="word", font=("Arial", 12))
        content.insert("1.0", deckblatt_text)
        content.pack(expand=True, fill="both", padx=10, pady=10)

    elif option == "Motivationsschreiben":
        # Vorher definierter Motivationsschreiben-Text
        motivation_text = (
            f"Dein Name: {name_entry.get()}\n"
            f"Deine Adresse\n"
            f"PLZ, Ort\n"
            f"Telefonnummer: {telefon_entry.get()}\n"
            f"E-Mail-Adresse\n"
            f"Datum: {datetime.now().strftime('%Y-%m-%d')}\n\n"
            f"Unternehmen: {firma_entry.get()}\n"
            f"Abteilung (optional)\n"
            f"Adresse des Unternehmens\n"
            f"PLZ, Ort\n\n"
            f"Betreff: Bewerbung als [Position/Titel der Stelle]\n\n"
            "Sehr geehrte Damen und Herren,\n\n"
            f"mit großem Interesse habe ich Ihre Stellenausschreibung gelesen, die mich aufgrund meiner Kenntnisse und Erfahrung im Bereich {beruf_var.get()} anspricht.\n\n"
            "Mit freundlichen Grüßen,\n"
            f"{name_entry.get()}"
        )
        content = Text(frame, wrap="word", font=("Arial", 12))
        content.insert("1.0", motivation_text)
        content.pack(expand=True, fill="both", padx=10, pady=10)
        
    elif option == "Lebenslauf Schreiben":
        lebenslauf_datei = "lebenslauf.txt"
        lebenslauf_vorlage = (
            "Lebenslauf\n"
            "-----------\n\n"
            "Name: [Ihr Name]\n"
            "Adresse: [Ihre Adresse]\n"
            "Telefonnummer: [Ihre Telefonnummer]\n"
            "E-Mail: [Ihre E-Mail-Adresse]\n\n"
            "Berufserfahrung:\n"
            "1. Position: [Beispiel: Softwareentwickler bei Firma XYZ]\n"
            "   Zeitraum: [Beispiel: Juni 2018 - Januar 2022]\n"
            "   Aufgaben: [Aufzählung von Aufgaben und Erfolgen]\n\n"
            "2. Position: [weitere Positionen]\n\n"
            "Ausbildung:\n"
            "1. Studium/Abschluss: [Beispiel: Bachelor in Informatik]\n"
            "   Universität: [Beispiel: Universität ABC]\n"
            "   Zeitraum: [Beispiel: 2014 - 2018]\n\n"
            "Fähigkeiten:\n"
            "- Programmiersprachen: Python, Java, C++\n"
            "- Tools: Git, Docker, Jenkins\n\n"
            "Sprachen:\n"
            "- Deutsch: Muttersprachlich\n"
            "- Englisch: Fließend\n"
        )

        # Überprüfen, ob die Lebenslauf-Datei existiert
        if not os.path.exists(lebenslauf_datei):
            # Wenn die Datei nicht existiert, wird die Vorlage erstellt und gespeichert
            with open(lebenslauf_datei, "w") as file:
                file.write(lebenslauf_vorlage)

        # Lebenslauf-Datei laden und letzten Bearbeitungsstand anzeigen
        with open(lebenslauf_datei, "r") as file:
            lebenslauf_content = file.read()

        # Letztes Änderungsdatum ermitteln
        last_modified = datetime.fromtimestamp(os.path.getmtime(lebenslauf_datei)).strftime('%d.%m.%Y %H:%M:%S')

        # Lebenslauf-Inhalt anzeigen
        content = Text(frame, wrap="word", font=("Arial", 12))
        content.insert("1.0", f"Zuletzt bearbeitet: {last_modified}\n\n{lebenslauf_content}")
        content.pack(expand=True, fill="both", padx=10, pady=10)

        # Speichern-Funktion für den Lebenslauf
        def speichern():
            with open(lebenslauf_datei, "w") as file:
                file.write(content.get("1.0", "end-1c"))
            messagebox.showinfo("Speichern", "Der Lebenslauf wurde erfolgreich gespeichert.")

        # Speichern-Button hinzufügen
        speichern_button = ctk.CTkButton(frame, text="Speichern", command=speichern)
        speichern_button.pack(pady=5)

# Lade Bewerbung aus der Datenbank
def lade_bewerbung(bewerbung_id):
    c.execute('SELECT betreff, nachricht FROM bewerbungen WHERE id=?', (bewerbung_id,))
    result = c.fetchone()
    if result:
        betreff, nachricht = result
        text_area.configure(state="normal")
        text_area.delete("1.0", "end")
        text_area.insert("1.0", f"Betreff: {betreff}\n\n{nachricht}")
        text_area.configure(state="normal")
        bewerbung_button.configure(state=NORMAL)  # Aktiviert den Bewerbung-Button nach Auswahl

    # Zurück zur Hauptansicht
    def zurueck_zur_hauptansicht():
        for widget in frame.winfo_children():
            widget.destroy()
        zeige_hauptfenster()

    zurueck_button = ctk.CTkButton(frame, text="Zurück", command=zurueck_zur_hauptansicht)
    zurueck_button.pack(pady=10)

# Hauptansicht
def zeige_hauptfenster():
    global name_entry, telefon_entry, beruf_var, firma_entry, ansprechpartner_entry, result_text

    ctk.CTkLabel(frame, text="Art der E-Mail:", font=("Helvetica", 16)).grid(row=0, column=0, sticky="w")
    ctk.CTkRadioButton(frame, text="Bewerbung", variable=art_var, value="Bewerbung", font=("Helvetica", 14)).grid(row=0, column=1, sticky="w")
    ctk.CTkRadioButton(frame, text="Anfrage", variable=art_var, value="Anfrage", font=("Helvetica", 14)).grid(row=0, column=2, sticky="w")

    ctk.CTkLabel(frame, text="Dein Name:", font=("Helvetica", 16)).grid(row=1, column=0, sticky="w")
    name_entry = ctk.CTkEntry(frame, width=450, font=("Helvetica", 14))
    name_entry.grid(row=1, column=1, columnspan=2)

    ctk.CTkLabel(frame, text="Tel.:", font=("Helvetica", 16)).grid(row=2, column=0, sticky="w")
    telefon_entry = ctk.CTkEntry(frame, width=450, font=("Helvetica", 14))
    telefon_entry.grid(row=2, column=1, columnspan=2)

    ctk.CTkLabel(frame, text="Praktikum im Bereich:", font=("Helvetica", 16)).grid(row=3, column=0, sticky="w", pady=(20, 0))
    beruf_var = ctk.StringVar(value="Fachinformatiker für Anwendungsentwicklung")
    ctk.CTkOptionMenu(frame, variable=beruf_var, values=["Fachinformatiker für Anwendungsentwicklung", "Fachinformatiker für Systemintegration"], font=("Helvetica", 14)).grid(row=3, column=1, columnspan=2)

    ctk.CTkLabel(frame, text="Firma:", font=("Helvetica", 16)).grid(row=4, column=0, sticky="w", pady=(10, 0))
    firma_entry = ctk.CTkEntry(frame, width=450, font=("Helvetica", 14))
    firma_entry.grid(row=4, column=1, columnspan=2)

    ctk.CTkLabel(frame, text="Ansprechpartner:", font=("Helvetica", 16)).grid(row=5, column=0, sticky="w", pady=(10, 0))
    ansprechpartner_entry = ctk.CTkEntry(frame, width=450, font=("Helvetica", 14))
    ansprechpartner_entry.grid(row=5, column=1, columnspan=2)

    result_text = Text(frame, height=20, width=60, wrap="word", font=("Helvetica", 12), padx=10, pady=10)
    result_text.grid(row=6, column=0, columnspan=3, padx=20, pady=20)

    speichern_button = ctk.CTkButton(frame, text="Bewerbung generieren und speichern", font=("Helvetica", 14), command=zeige_bewerbung)
    speichern_button.grid(row=7, column=0, columnspan=3, pady=10)

    historie_button = ctk.CTkButton(frame, text="Bewerbungshistorie", font=("Helvetica", 14), command=zeige_historie_fenster)
    historie_button.grid(row=8, column=0, columnspan=3, pady=10)

# Hauptfenster
app = ctk.CTk()
app.title("Bewerbungsassistent")
app.geometry()
app.configure(fg_color="#e6f0fa")

frame = ctk.CTkFrame(app, corner_radius=10)
frame.grid(row=0, column=0, sticky="nsew", padx=25, pady=25)

art_var = ctk.StringVar(value="Bewerbung")
zeige_hauptfenster()

app.mainloop()
