import tkinter as tk
from tkinter import ttk, messagebox, StringVar, Text, DISABLED, NORMAL
import sqlite3
from datetime import datetime
from fpdf import FPDF
import customtkinter as ctk
import time


# Ladebildschirm-Funktion
def ladebildschirm():
    root = tk.Tk()
    root.title("Ladebildschirm")
    root.geometry("600x400")
    root.configure(bg="#2E2E2E")  # Dunkelgrauer Hintergrund


    # Lade-Label
    lade_label = tk.Label(root, text="Wird geladen...", font=("Helvetica", 16), fg="white", bg="#2E2E2E")
    lade_label.pack(pady=40)  # Abstand zum Ladebalken


    # Ladebalken
    ladebalken = ttk.Progressbar(root, orient="horizontal", length=400, mode="determinate", maximum=100)
    ladebalken.pack(pady=20)  # Abstand zum Text


    # Lade-Logik
    def lade():
        for i in range(101):
            time.sleep(0.03)  # Wartezeit simulieren
            ladebalken["value"] = i
            root.update_idletasks()  # Updates das UI
        root.destroy()  # Schließt das Fenster nach dem Laden


    root.after(100, lade)  # Starte die Ladeanimation nach 100ms
    root.mainloop()


# Ladebildschirm anzeigen, bevor das Hauptprogramm startet
ladebildschirm()


# Datenbank-Verbindung
conn = sqlite3.connect('bewerbungen.db')
c = conn.cursor()


# Erstelle Tabelle, falls sie nicht vorhanden ist
c.execute('''
    CREATE TABLE IF NOT EXISTS bewerbungen (
        id INTEGER PRIMARY KEY,
        art TEXT,
        name TEXT,
        praktikum TEXT,
        firma TEXT,
        telefon TEXT,
        anrede TEXT,
        ansprechpartner TEXT,
        betreff TEXT,
        nachricht TEXT,
        date TEXT
    )
''')
conn.commit()


# Funktion zur Bestimmung der Anrede (Dummy-Funktion, falls erforderlich)
def determine_anrede(ansprechpartner):
    return 'Sehr geehrte/r'


# Funktion zum Speichern der Bewerbung in der Datenbank
def speichere_bewerbung(art, name, praktikum, firma, telefon, anrede, ansprechpartner, betreff, nachricht):
    datum = datetime.now().strftime("%Y-%m-%d %H:%M:%S")
    c.execute('''
        INSERT INTO bewerbungen (art, name, praktikum, firma, telefon, anrede, ansprechpartner, betreff, nachricht, date)
        VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
    ''', (art, name, praktikum, firma, telefon, anrede, ansprechpartner, betreff, nachricht, datum))
    conn.commit()


# Funktion zur Generierung der Bewerbung
def generiere_bewerbung(art, name, praktikum, firma, telefon, anrede, ansprechpartner):
    anrede = determine_anrede(ansprechpartner)
    betreff = f"{art} für ein Praktikum"
    nachricht = (
        f"{anrede} {ansprechpartner},\n\n"
        f"ich bin {name} und mache eine Umschulung im Bereich {praktikum}. "
        f"Mit großem Interesse habe ich von Ihrem Unternehmen {firma} gehört.\n\n"
        f"Mit freundlichen Grüßen,\n{name}\nTel.: {telefon}"
    )
    return betreff, nachricht


# Funktion zur Anzeige und Speicherung der Bewerbung
def zeige_bewerbung():
    art = art_var.get()
    name = name_entry.get()
    praktikum = beruf_var.get()
    firma = firma_entry.get()
    telefon = telefon_entry.get()
    ansprechpartner = ansprechpartner_entry.get()
    anrede = determine_anrede(ansprechpartner)
   
    betreff, nachricht = generiere_bewerbung(art, name, praktikum, firma, telefon, anrede, ansprechpartner)


    if betreff and nachricht:
        result_text.delete("1.0", "end")
        result_text.insert("end", f"Betreff: {betreff}\n\n{nachricht}")
        speichere_bewerbung(art, name, praktikum, firma, telefon, anrede, ansprechpartner, betreff, nachricht)
        if 'bewerbung_button' in globals():  # Prüft, ob bewerbung_button definiert ist
            bewerbung_button.configure(state=NORMAL)  # Aktiviert den Bewerbung-Button


# Funktion zur PDF-Erstellung
def speichere_als_pdf(text):
    pdf = FPDF()
    pdf.add_page()
    pdf.set_font("Arial", size=12)
    pdf.multi_cell(0, 10, text)
    dateiname = f"bewerbung_{datetime.now().strftime('%Y%m%d_%H%M%S')}.pdf"
    pdf.output(dateiname)
    messagebox.showinfo("Erfolg", f"PDF wurde gespeichert als {dateiname}!")


# Funktionen zur Textformatierung
def toggle_bold(text_widget):
    current_tags = text_widget.tag_names("sel.first")
    if "bold" in current_tags:
        text_widget.tag_remove("bold", "sel.first", "sel.last")
    else:
        text_widget.tag_add("bold", "sel.first", "sel.last")
        text_widget.tag_configure("bold", font=("Helvetica", 12, "bold"))


def toggle_italic(text_widget):
    current_tags = text_widget.tag_names("sel.first")
    if "italic" in current_tags:
        text_widget.tag_remove("italic", "sel.first", "sel.last")
    else:
        text_widget.tag_add("italic", "sel.first", "sel.last")
        text_widget.tag_configure("italic", font=("Helvetica", 12, "italic"))


def toggle_underline(text_widget):
    current_tags = text_widget.tag_names("sel.first")
    if "underline" in current_tags:
        text_widget.tag_remove("underline", "sel.first", "sel.last")
    else:
        text_widget.tag_add("underline", "sel.first", "sel.last")
        text_widget.tag_configure("underline", font=("Helvetica", 12, "underline"))


# Hauptfenster erstellen
app = ctk.CTk()
app.title("E-Mail Bewerbungsassistent")
app.geometry("800x730")  # Vergrößere das Fenster
app.configure(fg_color="#e6f0fa")


# Textvariable für den Inhalt (nach dem Hauptfenster erstellen)
content_text = StringVar()
content_text.set("Wähle eine Option links aus, um den Inhalt anzuzeigen.")


# Historienfenster anzeigen
def zeige_historie_fenster():
    global bewerbung_button, historie_window  # Macht bewerbung_button global zugänglich
   
    historie_window = ctk.CTkToplevel(app)
    historie_window.title("Bewerbungshistorie")
    historie_window.geometry("800x500")  # Vergrößertes Fenster für bessere Übersicht
    historie_window.configure(fg_color="#e6f0fa")


    # Setze das Historienfenster immer in den Vordergrund
    historie_window.transient(app)
    historie_window.grab_set()
    historie_window.attributes("-topmost", True)


    # Haupt-Frame für die Firmenliste und den Textbereich
    frame = ctk.CTkFrame(historie_window, fg_color="#e6f0fa")
    frame.pack(fill="both", expand=True, padx=10, pady=10)


    # Firmenliste mit Datum und Uhrzeit
    listbox_frame = ctk.CTkFrame(frame)
    listbox_frame.pack(side="left", fill="y", padx=10, pady=10)


    # Textbereich zur Anzeige und Bearbeitung der Bewerbung
    global text_area  # Globale Variable für die Textfläche
    text_area = Text(frame, height=20, width=60, wrap="word", padx=10, pady=10, font=("Helvetica", 12))
    text_area.pack(side="right", fill="both", expand=True)


    # Toolbar für Textformatierungen
    toolbar = ctk.CTkFrame(historie_window, fg_color="#e6f0fa")
    toolbar.pack(fill="x", padx=10)


    # Button für Fett, Kursiv, Unterstrichen, Bewerbung, PDF mit gleicher Breite
    bold_button = ctk.CTkButton(toolbar, text="Fett", command=lambda: toggle_bold(text_area), width=15)
    bold_button.pack(side="left", padx=5)


    italic_button = ctk.CTkButton(toolbar, text="Kursiv", command=lambda: toggle_italic(text_area), width=15)
    italic_button.pack(side="left", padx=5)


    underline_button = ctk.CTkButton(toolbar, text="Unterstrichen", command=lambda: toggle_underline(text_area), width=15)
    underline_button.pack(side="left", padx=5)


    pdf_button = ctk.CTkButton(toolbar, text="PDF", command=lambda: speichere_als_pdf(text_area.get("1.0", "end-1c")), width=15)
    pdf_button.pack(side="right", padx=5)


    # Bewerbungsbutton - angepasst auf die gleiche Größe wie andere Buttons
    bewerbung_button = ctk.CTkButton(toolbar, text="Bewerbung", font=("Arial", 12), command=zeige_bewerbung_inhalt, state=DISABLED, width=15)
    bewerbung_button.pack(side="right", padx=5)


    # Firmen und Daten aus der Datenbank abrufen
    c.execute('SELECT id, firma, date FROM bewerbungen')
    bewerbungen = c.fetchall()


    for bewerbung_id, firma, datum in bewerbungen:
        button = ctk.CTkButton(listbox_frame, text=f"{firma} - {datum}", command=lambda id=bewerbung_id: lade_bewerbung(id))
        button.pack(fill="x", pady=2)


# Funktion zur Anzeige des Inhalts für den Bewerbung-Button
def zeige_bewerbung_inhalt():
    # Anzeige des Bewerbungsinhalt im gleichen Fenster
    content_frame = ctk.CTkFrame(historie_window)
    content_frame.pack(fill="both", expand=True, padx=10, pady=10)
   
    # Linksseitige Auswahlbuttons
    left_frame = ctk.CTkFrame(content_frame, width=150)
    left_frame.pack(side="left", fill="y", padx=10, pady=10)


    # Rechter Frame zur Anzeige der Inhalte
    right_frame = ctk.CTkFrame(content_frame)
    right_frame.pack(side="right", expand=True, fill="both", padx=10, pady=10)


    # Optionen zur Auswahl
    options = ["Deckblatt Oberfläche", "Motivationsschreiben", "Lebenslauf Schreiben"]
    for option in options:
        button = ctk.CTkButton(left_frame, text=option, font=("Arial", 12), command=lambda opt=option: display_content(opt, right_frame))
        button.pack(pady=10, fill="x")
       
    # Buttons für Navigation: Vorwärts und Zurück
    prev_button = ctk.CTkButton(content_frame, text="Zurück", command=prev_content)
    prev_button.pack(side="left", padx=5)


    next_button = ctk.CTkButton(content_frame, text="Vorwärts", command=next_content)
    next_button.pack(side="right", padx=5)


# Anzeige von dynamischem Inhalt im rechten Frame
def display_content(option, frame):
    for widget in frame.winfo_children():
        widget.destroy()
   
    if option == "Deckblatt Oberfläche":
        content = "Hier ist die Oberfläche für das Deckblatt."
    elif option == "Motivationsschreiben":
        content = (
            "Dein Name\n"
            "Deine Adresse\n"
            "PLZ, Ort\n"
            "Telefonnummer\n"
            "E-Mail-Adresse\n"
            "Datum\n\n"
            "Unternehmen\n"
            "Abteilung (optional)\n"
            "Adresse des Unternehmens\n"
            "PLZ, Ort\n\n"
            "Betreff: Bewerbung als [Position/Titel der Stelle]\n\n"
            "Sehr geehrte Damen und Herren,\n\n"
            "mit großem Interesse habe ich Ihre Stellenausschreibung für die Position als [Titel der Stelle] gelesen, "
            "die mich aufgrund meiner [Kenntnisse, Erfahrung oder spezifische Motivation] sofort angesprochen hat. "
            "Durch meine Ausbildung/Erfahrung im Bereich [dein Fachgebiet] und meine Begeisterung für "
            "[relevantes Thema oder Fähigkeiten] bin ich überzeugt, einen wertvollen Beitrag zu Ihrem Team leisten zu können.\n\n"
            "In meiner bisherigen Laufbahn bei [früherer Arbeitgeber oder Ausbildungsstätte] konnte ich bereits umfassende "
            "Kenntnisse in [relevante Fachgebiete oder Skills] erwerben und erfolgreich in der Praxis anwenden. Ein Projekt, "
            "auf das ich besonders stolz bin, war [kurze Beschreibung eines relevanten Projekts oder Erfolges], das mir nicht "
            "nur [Erfahrungen oder Fähigkeiten] vermittelt hat, sondern mir auch gezeigt hat, wie sehr ich es schätze, in einem "
            "innovativen und dynamischen Umfeld zu arbeiten.\n\n"
            "Was mich besonders an Ihrem Unternehmen anspricht, ist [besondere Eigenschaft oder Werte des Unternehmens], die "
            "auch für mich eine hohe Bedeutung haben. Ich bin überzeugt, dass ich durch meine [relevante Fähigkeiten und "
            "persönliche Stärken] einen wertvollen Beitrag leisten und Ihr Team bereichern kann.\n\n"
            "Mit freundlichen Grüßen,\n"
            "[Dein Name]"
        )
    elif option == "Lebenslauf Schreiben":
        content = "Hier sind Beispiele und Vorlagen für das Schreiben eines Lebenslaufs."


    text_display = Text(frame, wrap="word", font=("Arial", 12))
    text_display.insert("1.0", content)
    text_display.pack(expand=True, fill="both", padx=10, pady=10)


# Lade Bewerbung aus der Datenbank
def lade_bewerbung(bewerbung_id):
    c.execute('SELECT betreff, nachricht FROM bewerbungen WHERE id=?', (bewerbung_id,))
    result = c.fetchone()
    if result:
        betreff, nachricht = result
        text_area.configure(state="normal")
        text_area.delete("1.0", "end")
        text_area.insert("1.0", f"Betreff: {betreff}\n\n{nachricht}")
        text_area.configure(state="normal")
        bewerbung_button.configure(state=NORMAL)  # Aktiviert den Bewerbung-Button nach Auswahl


# Hauptrahmen und Widgets
frame = ctk.CTkFrame(app, corner_radius=10)
frame.grid(row=0, column=0, sticky="nsew", padx=25, pady=25)


art_var = ctk.StringVar(value="Bewerbung")
ctk.CTkLabel(frame, text="Art der E-Mail:", font=("Helvetica", 16)).grid(row=0, column=0, sticky="w")
ctk.CTkRadioButton(frame, text="Bewerbung", variable=art_var, value="Bewerbung", font=("Helvetica", 14)).grid(row=0, column=1, sticky="w")
ctk.CTkRadioButton(frame, text="Anfrage", variable=art_var, value="Anfrage", font=("Helvetica", 14)).grid(row=0, column=2, sticky="w")


ctk.CTkLabel(frame, text="Dein Name:", font=("Helvetica", 16)).grid(row=1, column=0, sticky="w")
name_entry = ctk.CTkEntry(frame, width=450, font=("Helvetica", 14))
name_entry.grid(row=1, column=1, columnspan=2)


ctk.CTkLabel(frame, text="Tel.:", font=("Helvetica", 16)).grid(row=2, column=0, sticky="w")
telefon_entry = ctk.CTkEntry(frame, width=450, font=("Helvetica", 14))
telefon_entry.grid(row=2, column=1, columnspan=2)


ctk.CTkLabel(frame, text="Praktikum im Bereich:", font=("Helvetica", 16)).grid(row=3, column=0, sticky="w", pady=(20, 0))
beruf_var = ctk.StringVar(value="Fachinformatiker für Anwendungsentwicklung")
ctk.CTkOptionMenu(frame, variable=beruf_var, values=["Fachinformatiker für Anwendungsentwicklung", "Fachinformatiker für Systemintegration"], font=("Helvetica", 14)).grid(row=3, column=1, columnspan=2)


ctk.CTkLabel(frame, text="Firma:", font=("Helvetica", 16)).grid(row=4, column=0, sticky="w", pady=(10, 0))
firma_entry = ctk.CTkEntry(frame, width=450, font=("Helvetica", 14))
firma_entry.grid(row=4, column=1, columnspan=2)


ctk.CTkLabel(frame, text="Ansprechpartner:", font=("Helvetica", 16)).grid(row=5, column=0, sticky="w", pady=(10, 0))
ansprechpartner_entry = ctk.CTkEntry(frame, width=450, font=("Helvetica", 14))
ansprechpartner_entry.grid(row=5, column=1, columnspan=2)


result_text = Text(frame, height=20, width=60, wrap="word", font=("Helvetica", 12), padx=10, pady=10)
result_text.grid(row=6, column=0, columnspan=3, padx=20, pady=20)


speichern_button = ctk.CTkButton(frame, text="Bewerbung generieren und speichern", font=("Helvetica", 14), command=zeige_bewerbung)
speichern_button.grid(row=7, column=0, columnspan=3, pady=10)


historie_button = ctk.CTkButton(frame, text="Bewerbungshistorie", font=("Helvetica", 14), command=zeige_historie_fenster)
historie_button.grid(row=8, column=0, columnspan=3, pady=10)


app.mainloop()
